/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.internal;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.FormValidator;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.NumericDocument;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.action.ActionButton;

public class NumericInputDialog
extends JDialog {
    private Action cancelAction;
    private Action confirmAction;
    private boolean boundedRange;
    private JLabel icon;
    private JLabel message;
    private JLabel valueMessage;
    private JSlider valueSlider;
    private JTextField textField;
    private boolean confirmed;
    private FormValidator formValidator;

    public NumericInputDialog() {
        this.initialize();
    }

    public NumericInputDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    public NumericInputDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    public NumericInputDialog(Frame owner, String title) {
        super(owner, title);
        this.initialize();
    }

    public NumericInputDialog(Dialog owner) {
        super(owner);
        this.initialize();
    }

    public NumericInputDialog(Dialog owner, boolean modal) {
        super(owner, modal);
        this.initialize();
    }

    public NumericInputDialog(Dialog owner, String title) {
        super(owner, title);
        this.initialize();
    }

    public NumericInputDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initialize();
    }

    public NumericInputDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initialize();
    }

    private void initialize() {
        ResourceBundle resources = ResourceBundle.getBundle("org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages");
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowCloseHandler());
        this.cancelAction = new CancelAction(resources);
        this.confirmAction = new ConfirmAction(resources);
        SyncValuesHandler syncValuesHandler = new SyncValuesHandler();
        this.message = new JLabel();
        this.icon = new JLabel();
        this.icon.setVisible(false);
        this.icon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.valueMessage = new JLabel();
        this.valueMessage.setVisible(false);
        this.valueSlider = new JSlider();
        this.textField = new JTextField();
        this.textField.setDocument(new NumericDocument());
        this.textField.setColumns(10);
        this.textField.setHorizontalAlignment(11);
        this.textField.getDocument().addDocumentListener(syncValuesHandler);
        this.valueSlider.addChangeListener(syncValuesHandler);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        contentPane.add((Component)this.icon, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        contentPane.add((Component)this.message, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        contentPane.add((Component)this.valueSlider, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        contentPane.add((Component)this.textField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        contentPane.add((Component)this.valueMessage, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        contentPane.add((Component)this.createButtonPanel(), gbc);
        this.formValidator = new DialogValidator();
        this.formValidator.setEnabled(true);
        this.formValidator.registerTextField(this.textField);
        this.setContentPane(contentPane);
    }

    private JPanel createButtonPanel() {
        ActionButton btnCancel = new ActionButton(this.getCancelAction());
        ActionButton btnConfirm = new ActionButton(this.getConfirmAction());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        buttonPanel.add(btnConfirm);
        buttonPanel.add(btnCancel);
        btnConfirm.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(btnConfirm);
        buttonPanel.registerKeyboardAction(this.getConfirmAction(), KeyStroke.getKeyStroke(10, 0), 1);
        JPanel buttonCarrier = new JPanel();
        buttonCarrier.setLayout(new FlowLayout(2));
        buttonCarrier.add(buttonPanel);
        return buttonCarrier;
    }

    public boolean getPaintTicks() {
        return this.valueSlider.getPaintTicks();
    }

    public void setPaintTicks(boolean b) {
        this.valueSlider.setPaintTicks(b);
    }

    public void setSnapToTicks(boolean b) {
        this.valueSlider.setSnapToTicks(b);
    }

    public boolean getSnapToTicks() {
        return this.valueSlider.getSnapToTicks();
    }

    public Action getCancelAction() {
        return this.cancelAction;
    }

    public Action getConfirmAction() {
        return this.confirmAction;
    }

    public void setIcon(Icon icon) {
        this.icon.setIcon(icon);
        this.icon.setVisible(icon != null);
    }

    public Icon getIcon() {
        return this.icon.getIcon();
    }

    public String getMessage() {
        return this.message.getText();
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public int getSliderValue() {
        return this.valueSlider.getValue();
    }

    public void setSliderValue(int n) {
        this.valueSlider.setValue(n);
    }

    public int getMinimum() {
        return this.valueSlider.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.valueSlider.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.valueSlider.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.valueSlider.setMaximum(maximum);
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    protected boolean performValidate() {
        Integer value = this.getInputValue();
        if (value == null) {
            return false;
        }
        if (!this.isBoundedRange()) {
            return true;
        }
        int iVal = value;
        return iVal >= this.valueSlider.getMinimum() && iVal <= this.valueSlider.getMaximum();
    }

    public void setInputValue(Integer value) {
        if (value == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(String.valueOf(value));
        }
    }

    public Integer getInputValue() {
        try {
            return new Integer(this.textField.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public boolean isBoundedRange() {
        return this.boundedRange;
    }

    public void setBoundedRange(boolean boundedRange) {
        this.boundedRange = boundedRange;
    }

    public boolean isSliderVisible() {
        return this.valueSlider.isVisible();
    }

    public void setSliderVisible(boolean b) {
        this.valueSlider.setVisible(b);
    }

    public boolean isTextInputVisible() {
        return this.textField.isVisible();
    }

    public void setTextInputVisible(boolean b) {
        this.textField.setVisible(b);
        this.valueMessage.setVisible(!b);
    }

    private static NumericInputDialog createDialog(Component parent) {
        if (parent != null) {
            Window window = SwingUtil.getWindowAncestor(parent);
            if (window instanceof Dialog) {
                return new NumericInputDialog((Dialog)window, true);
            }
            if (window instanceof Frame) {
                return new NumericInputDialog((Frame)window, true);
            }
        }
        NumericInputDialog dialog = new NumericInputDialog();
        dialog.setModal(true);
        return dialog;
    }

    public static Integer showInputDialog(Component parent, int icon, String title, String message, int minimum, int maximum, int initialValue, boolean bounded) {
        NumericInputDialog dialog = NumericInputDialog.createDialog(parent);
        if (title != null) {
            dialog.setTitle(title);
        }
        if (message != null) {
            dialog.setMessage(message);
        }
        dialog.setIcon(NumericInputDialog.createDefaultIcon(icon));
        dialog.setMinimum(minimum);
        dialog.setMaximum(maximum);
        dialog.setInputValue(new Integer(initialValue));
        dialog.setBoundedRange(bounded);
        dialog.setPaintTicks(true);
        dialog.pack();
        SwingUtil.centerDialogInParent(dialog);
        dialog.setVisible(true);
        if (dialog.isConfirmed()) {
            return dialog.getInputValue();
        }
        return null;
    }

    public static Integer showInputDialog(Component parent, int icon, String title, String message, int initialValue, boolean bounded) {
        NumericInputDialog dialog = NumericInputDialog.createDialog(parent);
        if (title != null) {
            dialog.setTitle(title);
        }
        if (message != null) {
            dialog.setMessage(message);
        }
        dialog.setIcon(NumericInputDialog.createDefaultIcon(icon));
        dialog.setInputValue(new Integer(initialValue));
        dialog.setSliderVisible(false);
        dialog.setBoundedRange(bounded);
        dialog.pack();
        SwingUtil.centerDialogInParent(dialog);
        dialog.setVisible(true);
        if (dialog.isConfirmed()) {
            return dialog.getInputValue();
        }
        return null;
    }

    public static Integer showSliderDialog(Component parent, int icon, String title, String message, int minimum, int maximum, int initialValue) {
        NumericInputDialog dialog = NumericInputDialog.createDialog(parent);
        if (title != null) {
            dialog.setTitle(title);
        }
        if (message != null) {
            dialog.setMessage(message);
        }
        dialog.setIcon(NumericInputDialog.createDefaultIcon(icon));
        dialog.setMinimum(minimum);
        dialog.setMaximum(maximum);
        dialog.setInputValue(new Integer(initialValue));
        dialog.setBoundedRange(true);
        dialog.setTextInputVisible(false);
        dialog.pack();
        SwingUtil.centerDialogInParent(dialog);
        dialog.setVisible(true);
        if (dialog.isConfirmed()) {
            return dialog.getInputValue();
        }
        return null;
    }

    private static Icon createDefaultIcon(int messageType) {
        String propertyName;
        switch (messageType) {
            case 0: {
                propertyName = "OptionPane.errorIcon";
                break;
            }
            case 1: {
                propertyName = "OptionPane.informationIcon";
                break;
            }
            case 2: {
                propertyName = "OptionPane.warningIcon";
                break;
            }
            case 3: {
                propertyName = "OptionPane.questionIcon";
                break;
            }
            default: {
                return null;
            }
        }
        return UIManager.getIcon(propertyName);
    }

    private class WindowCloseHandler
    extends WindowAdapter {
        protected WindowCloseHandler() {
        }

        public void windowClosing(WindowEvent e) {
            Action cancelAction = NumericInputDialog.this.getCancelAction();
            if (cancelAction != null) {
                cancelAction.actionPerformed(null);
            } else {
                NumericInputDialog.this.setConfirmed(false);
                NumericInputDialog.this.setVisible(false);
            }
        }
    }

    private class DialogValidator
    extends FormValidator {
        protected DialogValidator() {
        }

        public boolean performValidate() {
            return NumericInputDialog.this.performValidate();
        }

        public Action getConfirmAction() {
            return NumericInputDialog.this.getConfirmAction();
        }
    }

    private class CancelAction
    extends AbstractAction {
        protected CancelAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("OptionPane.cancelButtonText"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        public void actionPerformed(ActionEvent e) {
            NumericInputDialog.this.setConfirmed(false);
            NumericInputDialog.this.setVisible(false);
        }
    }

    private class ConfirmAction
    extends AbstractAction {
        protected ConfirmAction(ResourceBundle resources) {
            this.putValue("Name", resources.getString("OptionPane.okButtonText"));
        }

        public void actionPerformed(ActionEvent e) {
            if (NumericInputDialog.this.performValidate()) {
                NumericInputDialog.this.setConfirmed(true);
                NumericInputDialog.this.setVisible(false);
            }
        }
    }

    private class SyncValuesHandler
    implements DocumentListener,
    ChangeListener {
        private boolean inStateChange;

        private SyncValuesHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertUpdate(DocumentEvent e) {
            if (this.inStateChange) {
                return;
            }
            this.inStateChange = true;
            try {
                Integer i = NumericInputDialog.this.getInputValue();
                if (i != null) {
                    NumericInputDialog.this.valueSlider.setValue(i);
                    NumericInputDialog.this.valueMessage.setText(String.valueOf(i));
                }
            }
            finally {
                this.inStateChange = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent e) {
            if (this.inStateChange) {
                return;
            }
            this.inStateChange = true;
            try {
                Integer i = NumericInputDialog.this.getInputValue();
                if (i != null) {
                    NumericInputDialog.this.valueSlider.setValue(i);
                    NumericInputDialog.this.valueMessage.setText(String.valueOf(i));
                }
            }
            finally {
                this.inStateChange = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changedUpdate(DocumentEvent e) {
            if (this.inStateChange) {
                return;
            }
            this.inStateChange = true;
            try {
                Integer i = NumericInputDialog.this.getInputValue();
                if (i != null) {
                    NumericInputDialog.this.valueSlider.setValue(i);
                    NumericInputDialog.this.valueMessage.setText(String.valueOf(i));
                }
            }
            finally {
                this.inStateChange = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent e) {
            if (this.inStateChange) {
                return;
            }
            this.inStateChange = true;
            try {
                String text = String.valueOf(NumericInputDialog.this.valueSlider.getValue());
                NumericInputDialog.this.textField.setText(text);
                NumericInputDialog.this.valueMessage.setText(text);
            }
            finally {
                this.inStateChange = false;
            }
        }
    }
}

