/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters;

import java.util.Date;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ButtonParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.CheckBoxParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.DatePickerParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.DropDownParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ListParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponentFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterUpdateContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.RadioButtonParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.TextAreaParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.TextFieldParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.KeyedComboBoxModel;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterValues;

public class DefaultParameterComponentFactory
implements ParameterComponentFactory {
    public ParameterComponent create(ParameterDefinitionEntry entry, ParameterContext parameterContext, ParameterUpdateContext updateContext) {
        if (entry instanceof ListParameter) {
            return this.createListParameter((ListParameter)entry, parameterContext, updateContext);
        }
        return this.createTextComponent(entry, parameterContext, updateContext);
    }

    public ParameterComponent createListParameter(ListParameter listParameter, ParameterContext parameterContext, ParameterUpdateContext updateContext) {
        String type = listParameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", parameterContext);
        if (type == null || "textbox".equals(type)) {
            return this.createTextComponent(listParameter, parameterContext, updateContext);
        }
        if ("dropdown".equals(type)) {
            return new DropDownParameterComponent(listParameter, updateContext, parameterContext);
        }
        if ("list".equals(type)) {
            return new ListParameterComponent(listParameter, updateContext, parameterContext);
        }
        if ("checkbox".equals(type)) {
            return new CheckBoxParameterComponent(listParameter, updateContext, parameterContext);
        }
        if ("radio".equals(type)) {
            return new RadioButtonParameterComponent(listParameter, updateContext, parameterContext);
        }
        if ("togglebutton".equals(type)) {
            return new ButtonParameterComponent(listParameter, updateContext, parameterContext);
        }
        return this.createTextComponent(listParameter, parameterContext, updateContext);
    }

    private ParameterComponent createTextComponent(ParameterDefinitionEntry entry, ParameterContext parameterContext, ParameterUpdateContext updateContext) {
        String type = entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-render-type", parameterContext);
        if ("datepicker".equals(type) && Date.class.isAssignableFrom(entry.getValueType())) {
            return new DatePickerParameterComponent(entry, parameterContext, updateContext);
        }
        if ("multi-line".equals(type)) {
            return new TextAreaParameterComponent(entry, parameterContext, updateContext);
        }
        return new TextFieldParameterComponent(entry, parameterContext, updateContext);
    }

    public static KeyedComboBoxModel createModel(ListParameter parameter, ParameterContext parameterContext) throws ReportDataFactoryException {
        ParameterValues paramValues = parameter.getValues(parameterContext);
        int count = paramValues.getRowCount();
        Object[] keys = new Object[count];
        Object[] values = new Object[count];
        for (int i = 0; i < count; ++i) {
            Object key;
            keys[i] = key = paramValues.getKeyValue(i);
            values[i] = paramValues.getTextValue(i);
        }
        KeyedComboBoxModel model = new KeyedComboBoxModel();
        model.setData(keys, values);
        return model;
    }
}

