/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters;

import java.awt.Component;
import java.awt.Dimension;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.MinimalScrollPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.DefaultParameterComponentFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterUpdateContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.KeyedComboBoxModel;
import org.pentaho.reporting.engine.classic.core.parameters.ListParameter;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class ListParameterComponent
extends MinimalScrollPane
implements ParameterComponent {
    private ListParameter listParameter;
    private ParameterContext parameterContext;
    private ParameterUpdateContext updateContext;
    private JList list;
    private boolean adjustingToUserInput;
    private boolean adjustingToExternalInput;
    private ArrayList<Integer> selectionCache;
    private ListUpdateHandler changeListener;

    public ListParameterComponent(ListParameter listParameter, ParameterUpdateContext updateContext, ParameterContext parameterContext) {
        this.listParameter = listParameter;
        this.updateContext = updateContext;
        this.parameterContext = parameterContext;
        this.selectionCache = new ArrayList();
        this.list = new JList();
        this.list.setCellRenderer(new FixedTheJDKListCellRenderer());
        if (listParameter.isAllowMultiSelection()) {
            this.list.addListSelectionListener(new MultiValueListParameterHandler(listParameter.getName()));
            this.list.setSelectionMode(2);
        } else {
            this.list.addListSelectionListener(new SingleValueListParameterHandler(listParameter.getName()));
            this.list.setSelectionMode(0);
        }
        String layout = listParameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-layout", parameterContext);
        if ("horizontal".equals(layout)) {
            this.list.setLayoutOrientation(2);
            this.list.setVisibleRowCount(1);
            this.list.setPreferredSize(new Dimension((int)this.list.getMinimumSize().getWidth(), 25));
        } else {
            String visibleItemsText = listParameter.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "parameter-visible-items", parameterContext);
            int visibleItems = ParserUtil.parseInt((String)visibleItemsText, (int)0);
            if (visibleItems > 0) {
                this.list.setVisibleRowCount(visibleItems);
            }
        }
        this.setViewportView(this.list);
        this.getViewport().setMinimumSize(this.list.getPreferredScrollableViewportSize());
        this.setHorizontalScrollBarPolicy(31);
        this.setVerticalScrollBarPolicy(20);
        this.changeListener = new ListUpdateHandler();
        updateContext.addChangeListener(this.changeListener);
    }

    public JComponent getUIComponent() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws ReportDataFactoryException {
        this.adjustingToExternalInput = true;
        try {
            KeyedComboBoxModel keyedComboBoxModel = DefaultParameterComponentFactory.createModel(this.listParameter, this.parameterContext);
            this.list.setModel(keyedComboBoxModel);
            ListSelectionModel selectionModel = this.list.getSelectionModel();
            Object value = this.updateContext.getParameterValue(this.listParameter.getName());
            HashSet keylist = this.getNormalizedSet(value);
            selectionModel.setValueIsAdjusting(true);
            this.list.clearSelection();
            int size = keyedComboBoxModel.getSize();
            for (int i = 0; i < size; ++i) {
                Object key = keyedComboBoxModel.getKeyAt(i);
                if (!this.isSafeMatch(key, keylist)) continue;
                selectionModel.addSelectionInterval(i, i);
            }
            selectionModel.setValueIsAdjusting(false);
        }
        finally {
            this.adjustingToExternalInput = false;
        }
    }

    private boolean isSafeMatch(Object key, Collection values) {
        for (Object value : values) {
            BigDecimal bdV;
            BigDecimal bdK;
            if (key == value) {
                return true;
            }
            if (key != null && key.equals(value)) {
                return true;
            }
            if (key instanceof Number && value instanceof Number && (bdK = new BigDecimal(key.toString())).compareTo(bdV = new BigDecimal(value.toString())) == 0) {
                return true;
            }
            if (!(key instanceof Date) || !(value instanceof Date)) continue;
            Date d1 = (Date)key;
            Date d2 = (Date)value;
            if (d1.getTime() != d2.getTime()) continue;
            return true;
        }
        return false;
    }

    protected JList getList() {
        return this.list;
    }

    private HashSet getNormalizedSet(Object o) {
        HashSet<Object> set = new HashSet<Object>();
        if (o instanceof Object[]) {
            Object[] oa = (Object[])o;
            set.addAll(Arrays.asList(oa));
        } else if (o instanceof Collection) {
            set.addAll((Collection)o);
        } else {
            set.add(o);
        }
        return set;
    }

    private static class FixedTheJDKListCellRenderer
    extends DefaultListCellRenderer {
        private FixedTheJDKListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent((JList<?>)list, "<null>", index, isSelected, cellHasFocus);
            }
            if ("".equals(value)) {
                return super.getListCellRendererComponent((JList<?>)list, " ", index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class MultiValueListParameterHandler
    implements ListSelectionListener {
        private String key;

        public MultiValueListParameterHandler(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent e) {
            if (ListParameterComponent.this.adjustingToExternalInput || ListParameterComponent.this.adjustingToUserInput) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            try {
                int index;
                ListParameterComponent.this.adjustingToUserInput = true;
                KeyedComboBoxModel listModel = (KeyedComboBoxModel)ListParameterComponent.this.list.getModel();
                ListSelectionModel selectionModel = ListParameterComponent.this.list.getSelectionModel();
                selectionModel.setValueIsAdjusting(true);
                HashSet<Integer> newSelections = new HashSet<Integer>();
                int size = listModel.getSize();
                for (int i = 0; i < size; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    newSelections.add(IntegerCache.getInteger(i));
                }
                for (Integer integer : ListParameterComponent.this.selectionCache) {
                    index = integer;
                    selectionModel.addSelectionInterval(index, index);
                }
                if (!newSelections.containsAll(ListParameterComponent.this.selectionCache)) {
                    for (Integer nextInt : newSelections) {
                        index = nextInt;
                        if (ListParameterComponent.this.selectionCache.contains(nextInt)) {
                            selectionModel.removeSelectionInterval(index, index);
                            continue;
                        }
                        selectionModel.addSelectionInterval(index, index);
                    }
                    ListParameterComponent.this.selectionCache.clear();
                    for (int i = 0; i < size; ++i) {
                        if (!selectionModel.isSelectedIndex(i)) continue;
                        ListParameterComponent.this.selectionCache.add(IntegerCache.getInteger(i));
                    }
                }
                selectionModel.setValueIsAdjusting(false);
                int[] indices = ListParameterComponent.this.list.getSelectedIndices();
                Object[] keys = new Object[indices.length];
                for (int i = 0; i < keys.length; ++i) {
                    int index2 = indices[i];
                    keys[i] = listModel.getKeyAt(index2);
                }
                ListParameterComponent.this.updateContext.setParameterValue(this.key, keys);
            }
            finally {
                ListParameterComponent.this.adjustingToUserInput = false;
            }
        }
    }

    private class SingleValueListParameterHandler
    implements ListSelectionListener {
        private String key;

        public SingleValueListParameterHandler(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent e) {
            if (ListParameterComponent.this.adjustingToExternalInput || ListParameterComponent.this.adjustingToUserInput) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            try {
                ListParameterComponent.this.adjustingToUserInput = true;
                KeyedComboBoxModel theModel = (KeyedComboBoxModel)ListParameterComponent.this.list.getModel();
                int index = ListParameterComponent.this.list.getSelectedIndex();
                if (index == -1) {
                    ListParameterComponent.this.updateContext.setParameterValue(this.key, null);
                } else {
                    ListParameterComponent.this.updateContext.setParameterValue(this.key, theModel.getKeyAt(index));
                }
            }
            finally {
                ListParameterComponent.this.adjustingToUserInput = false;
            }
        }
    }

    private class ListUpdateHandler
    implements ChangeListener {
        private ListUpdateHandler() {
        }

        public void stateChanged(ChangeEvent e) {
            if (ListParameterComponent.this.adjustingToUserInput) {
                return;
            }
            try {
                ListParameterComponent.this.initialize();
            }
            catch (ReportDataFactoryException rdfe) {
                throw new IndexOutOfBoundsException("Failed:" + rdfe.getMessage());
            }
        }
    }
}

