/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public abstract class AbstractActionPlugin
implements ActionPlugin {
    public static final String ENABLED_PROPERTY = "enabled";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ResourceBundleSupport baseResources;
    private IconTheme iconTheme;
    private SwingGuiContext context;
    private ExtendedConfiguration configuration;
    private boolean enabled = true;

    protected AbstractActionPlugin() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.propertyChangeSupport.firePropertyChange(ENABLED_PROPERTY, oldEnabled, enabled);
    }

    public boolean initialize(SwingGuiContext context) {
        if (context == null) {
            throw new NullPointerException("AbstractActionPlugin.initialize(..): Context parameter cannot be null");
        }
        if (this.context != context) {
            this.context = context;
            this.iconTheme = context.getIconTheme();
            this.configuration = new ExtendedConfigurationWrapper(context.getConfiguration());
            this.baseResources = new ResourceBundleSupport(context.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
        }
        return true;
    }

    public void deinitialize(SwingGuiContext swingGuiContext) {
        this.context = null;
    }

    public ResourceBundleSupport getBaseResources() {
        return this.baseResources;
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public SwingGuiContext getContext() {
        return this.context;
    }

    public ExtendedConfiguration getConfig() {
        return this.configuration;
    }

    public boolean isSeparated() {
        return this.getConfig().getBoolProperty(this.getConfigurationPrefix() + "separated");
    }

    public boolean isAddToToolbar() {
        return this.getConfig().getBoolProperty(this.getConfigurationPrefix() + "add-to-toolbar");
    }

    public boolean isAddToMenu() {
        String name = this.getConfigurationPrefix() + "add-to-menu";
        return this.getConfig().getBoolProperty(name);
    }

    protected ReportProgressDialog createProgressDialog() {
        Window proxy = this.context.getWindow();
        if (proxy instanceof Frame) {
            return new ReportProgressDialog((Frame)proxy);
        }
        if (proxy instanceof Dialog) {
            return new ReportProgressDialog((Dialog)proxy);
        }
        return new ReportProgressDialog();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(property, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public IconTheme getIconTheme() {
        return this.iconTheme;
    }

    protected abstract String getConfigurationPrefix();

    public int getMenuOrder() {
        return this.getConfig().getIntProperty(this.getConfigurationPrefix() + "menu-order", 0);
    }

    public int getToolbarOrder() {
        return this.getConfig().getIntProperty(this.getConfigurationPrefix() + "toolbar-order", 0);
    }

    public String getRole() {
        return this.getConfig().getConfigProperty(this.getConfigurationPrefix() + "role");
    }

    public int getRolePreference() {
        return this.getConfig().getIntProperty(this.getConfigurationPrefix() + "role-preference", 0);
    }
}

