/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportEventSource;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class AbstractExportActionPlugin
extends AbstractActionPlugin
implements ExportActionPlugin {
    private static final Log logger = LogFactory.getLog(AbstractExportActionPlugin.class);
    private ReportEventSource eventSource;
    private Messages messages;
    private ReportJobListener reportJobUpdateHandler = new ReportJobListener();

    protected AbstractExportActionPlugin() {
        this.messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
    }

    public boolean initialize(SwingGuiContext context) {
        SwingGuiContext oldContext = this.getContext();
        if (!super.initialize(context)) {
            return false;
        }
        if (oldContext != null && this.eventSource != null) {
            this.eventSource.removePropertyChangeListener("reportJob", this.reportJobUpdateHandler);
        }
        if (oldContext != context) {
            this.messages = new Messages(context.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
            this.eventSource = context.getEventSource();
            this.eventSource.addPropertyChangeListener("reportJob", this.reportJobUpdateHandler);
            this.setEnabled(this.eventSource.getReportJob() != null);
        }
        return true;
    }

    public void deinitialize(SwingGuiContext swingGuiContext) {
        super.deinitialize(swingGuiContext);
        if (swingGuiContext != null && this.eventSource != null) {
            this.eventSource.removePropertyChangeListener("reportJob", this.reportJobUpdateHandler);
        }
    }

    protected ExportDialog createExportDialog(String className) throws InstantiationException {
        ClassLoader classLoader;
        if (className == null) {
            throw new NullPointerException("No classname given");
        }
        Window proxy = this.getContext().getWindow();
        if (proxy instanceof Frame) {
            classLoader = ObjectUtilities.getClassLoader(AbstractActionPlugin.class);
            try {
                Class<?> aClass = Class.forName(className, true, classLoader);
                Constructor<?> constructor = aClass.getConstructor(Frame.class);
                return (ExportDialog)constructor.newInstance(proxy);
            }
            catch (Exception e) {
                logger.error((Object)this.messages.getErrorString("AbstractExportActionPlugin.ERROR_0001_FAILED_EXPORT_DIALOG_CREATION", className));
            }
        } else if (proxy instanceof Dialog) {
            classLoader = ObjectUtilities.getClassLoader(AbstractActionPlugin.class);
            try {
                Class<?> aClass = Class.forName(className, true, classLoader);
                Constructor<?> constructor = aClass.getConstructor(Dialog.class);
                return (ExportDialog)constructor.newInstance(proxy);
            }
            catch (Exception e) {
                logger.error((Object)this.messages.getErrorString("AbstractExportActionPlugin.ERROR_0002_FAILED_EXPORT_DIALOG_CREATION", className), (Throwable)e);
            }
        }
        Object fallBack = ObjectUtilities.loadAndInstantiate((String)className, AbstractActionPlugin.class, ExportDialog.class);
        if (fallBack != null) {
            return (ExportDialog)fallBack;
        }
        logger.error((Object)this.messages.getErrorString("AbstractExportActionPlugin.ERROR_0003_FAILED_EXPORT_DIALOG_CREATION", className));
        throw new InstantiationException(this.messages.getErrorString("AbstractExportActionPlugin.ERROR_0004_FAILED_EXPORT_DIALOG_CREATION"));
    }

    public boolean performShowExportDialog(MasterReport job, String configKey) {
        try {
            Configuration configuration = job.getConfiguration();
            String dialogClassName = configuration.getConfigProperty(configKey);
            ExportDialog dialog = this.createExportDialog(dialogClassName);
            return dialog.performQueryForExport(job, this.getContext());
        }
        catch (InstantiationException e) {
            logger.error((Object)this.messages.getErrorString("AbstractExportActionPlugin.ERROR_0005_UNABLE_TO_CONFIGURE"));
            this.getContext().getStatusListener().setStatus(StatusType.ERROR, this.messages.getString("AbstractExportActionPlugin.ERROR_0005_UNABLE_TO_CONFIGURE"), e);
            return false;
        }
    }

    protected boolean isProgressDialogEnabled(MasterReport report, String configKey) {
        return this.getConfig().getBoolProperty(configKey);
    }

    private class ReportJobListener
    implements PropertyChangeListener {
        protected ReportJobListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractExportActionPlugin.this.setEnabled(AbstractExportActionPlugin.this.eventSource.getReportJob() != null);
        }
    }
}

