/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ActionFactory;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DefaultActionFactory
implements ActionFactory {
    private static final Log logger = LogFactory.getLog(DefaultActionFactory.class);
    private static final ActionPlugin[] EMPTY_ACTIONS = new ActionPlugin[0];
    private static final String PREFIX = "org.pentaho.reporting.engine.classic.core.modules.gui.swing.actions.";
    private static final Messages MESSAGES = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));

    public ActionPlugin[] getActions(SwingGuiContext context, String category) {
        String prefix;
        if (context == null) {
            throw new NullPointerException();
        }
        if (category == null) {
            throw new NullPointerException();
        }
        Configuration configuration = context.getConfiguration();
        Iterator keys = configuration.findPropertyKeys(prefix = PREFIX + category);
        if (!keys.hasNext()) {
            logger.debug((Object)MESSAGES.getString("DefaultActionFactory.DEBUG_NO_ACTIONS", category));
            return EMPTY_ACTIONS;
        }
        HashMap<Object, ActionPlugin> plugins = new HashMap<Object, ActionPlugin>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String base = key.substring(prefix.length());
            if (!this.isPluginKey(base)) continue;
            String clazz = configuration.getConfigProperty(key);
            Object maybeActionPlugin = ObjectUtilities.loadAndInstantiate((String)clazz, DefaultActionFactory.class, ActionPlugin.class);
            if (maybeActionPlugin == null) {
                logger.debug((Object)MESSAGES.getString("DefaultActionFactory.DEBUG_NOT_ACTION_PLUGIN", category, clazz));
                continue;
            }
            ActionPlugin plugin = (ActionPlugin)maybeActionPlugin;
            if (!plugin.initialize(context)) {
                plugin.deinitialize(context);
                continue;
            }
            String role = plugin.getRole();
            if (role == null) {
                plugins.put(plugin, plugin);
                continue;
            }
            ActionPlugin otherPlugin = (ActionPlugin)plugins.get(role);
            if (otherPlugin != null) {
                if (plugin.getRolePreference() > otherPlugin.getRolePreference()) {
                    plugins.put(role, plugin);
                    otherPlugin.deinitialize(context);
                    continue;
                }
                logger.debug((Object)MESSAGES.getString("DefaultActionFactory.DEBUG_PLUGIN_OVERRIDE", category, clazz, otherPlugin.getClass().getName()));
                continue;
            }
            plugins.put(role, plugin);
        }
        logger.debug((Object)MESSAGES.getString("DefaultActionFactory.DEBUG_RETURNING_PLUGINS", String.valueOf(plugins.size()), category));
        return plugins.values().toArray(new ActionPlugin[plugins.size()]);
    }

    private boolean isPluginKey(String base) {
        if (base.length() < 1) {
            return false;
        }
        return base.indexOf(46, 1) <= 0;
    }
}

