/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingCommonModule;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class EncodingComboBoxModel
implements ComboBoxModel {
    private static final Log logger = LogFactory.getLog(EncodingComboBoxModel.class);
    public static final String AVAILABLE_ENCODINGS = "org.pentaho.reporting.engine.classic.core.modules.gui.base.EncodingsAvailable";
    public static final String AVAILABLE_ENCODINGS_ALL = "all";
    public static final String AVAILABLE_ENCODINGS_FILE = "file";
    public static final String AVAILABLE_ENCODINGS_NONE = "none";
    public static final String ENCODINGS_DEFINITION_FILE = "org.pentaho.reporting.engine.classic.core.modules.gui.base.EncodingsFile";
    public static final String ENCODINGS_DEFINITION_FILE_DEFAULT = "org/pentaho/reporting/engine/classic/core/modules/gui/commonswing/jfreereport-encodings.properties";
    private final ArrayList encodings;
    private ArrayList listDataListeners;
    private int selectedIndex;
    private Object selectedObject;
    private ResourceBundle bundle;
    public static final String BUNDLE_NAME = "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.encoding-names";
    private Messages messages;
    private String ENCODING_DEFAULT_DESCRIPTION;

    public EncodingComboBoxModel(Locale locale) {
        this.bundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        this.messages = new Messages(locale, "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
        this.ENCODING_DEFAULT_DESCRIPTION = this.messages.getString("EncodingComboBoxModel.USER_ENCODING_DEFAULT_DESCRIPTION");
        this.encodings = new ArrayList();
        this.listDataListeners = null;
        this.selectedIndex = -1;
    }

    public boolean addEncoding(String name, String description) {
        if (!EncodingRegistry.getInstance().isSupportedEncoding(name)) {
            return false;
        }
        this.encodings.add(new EncodingCarrier(name, description));
        this.fireContentsChanged();
        return true;
    }

    public void addEncodingUnchecked(String name, String description) {
        this.encodings.add(new EncodingCarrier(name, description));
        this.fireContentsChanged();
    }

    public void removeEncoding(String name) {
        if (this.encodings.remove(name)) {
            this.fireContentsChanged();
        }
    }

    public void ensureEncodingAvailable(String encoding) {
        if (encoding == null) {
            throw new NullPointerException(this.messages.getErrorString("EncodingComboBoxModel.ERROR_0001_ENCODING_CANNOT_BE_NULL"));
        }
        String desc = this.getEncodingDescription(encoding);
        EncodingCarrier ec = new EncodingCarrier(encoding, desc);
        if (!this.encodings.contains(ec)) {
            this.encodings.add(ec);
            this.fireContentsChanged();
        }
    }

    protected String getEncodingDescription(String encoding) {
        try {
            return this.bundle.getString(encoding);
        }
        catch (Exception e) {
            return this.ENCODING_DEFAULT_DESCRIPTION;
        }
    }

    public void sort() {
        Object selectedObject = this.getSelectedItem();
        Collections.sort(this.encodings, new EncodingCarrierComparator());
        this.setSelectedItem(selectedObject);
        this.fireContentsChanged();
    }

    protected void fireContentsChanged() {
        if (this.listDataListeners == null) {
            return;
        }
        this.fireContentsChanged(0, this.getSize());
    }

    protected void fireContentsChanged(int start, int length) {
        if (this.listDataListeners == null) {
            return;
        }
        ListDataEvent evt = new ListDataEvent(this, 0, start, length);
        for (int i = 0; i < this.listDataListeners.size(); ++i) {
            ListDataListener l = (ListDataListener)this.listDataListeners.get(i);
            l.contentsChanged(evt);
        }
    }

    public void setSelectedItem(Object anItem) {
        this.selectedObject = anItem;
        if (anItem instanceof String) {
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                if (!anItem.equals(this.getElementAt(i))) continue;
                this.selectedIndex = i;
                this.fireContentsChanged(-1, -1);
                return;
            }
        }
        this.selectedIndex = -1;
        this.fireContentsChanged(-1, -1);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            this.selectedIndex = -1;
            this.selectedObject = null;
            this.fireContentsChanged(-1, -1);
            return;
        }
        if (index < -1 || index >= this.getSize()) {
            throw new IllegalArgumentException(this.messages.getErrorString("EncodingComboBoxModel.ERROR_0001_INVALID_INDEX"));
        }
        this.selectedIndex = index;
        this.selectedObject = this.getElementAt(index);
        this.fireContentsChanged(-1, -1);
    }

    public String getSelectedEncoding() {
        if (this.selectedIndex == -1) {
            return null;
        }
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(this.selectedIndex);
        return ec.getName();
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.encodings.size();
    }

    public Object getElementAt(int index) {
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(index);
        return ec.getDisplayName();
    }

    public void addListDataListener(ListDataListener l) {
        if (this.listDataListeners == null) {
            this.listDataListeners = new ArrayList(5);
        }
        this.listDataListeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        if (this.listDataListeners == null) {
            return;
        }
        this.listDataListeners.remove(l);
    }

    public static EncodingComboBoxModel createDefaultModel(Locale locale) {
        return EncodingComboBoxModel.createDefaultModel(locale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncodingComboBoxModel createDefaultModel(Locale locale, boolean includeNull) {
        String availEncs;
        boolean allEncodings;
        EncodingComboBoxModel ecb = new EncodingComboBoxModel(locale);
        if (includeNull) {
            ecb.addEncodingUnchecked(null, "");
        }
        if ((allEncodings = (availEncs = EncodingComboBoxModel.getAvailableEncodings()).equalsIgnoreCase(AVAILABLE_ENCODINGS_ALL)) || availEncs.equals(AVAILABLE_ENCODINGS_FILE)) {
            String encFile = EncodingComboBoxModel.getEncodingsDefinitionFile();
            InputStream in = ObjectUtilities.getResourceAsStream((String)encFile, EncodingComboBoxModel.class);
            if (in == null) {
                Messages messages = new Messages(locale, "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
                logger.warn((Object)messages.getString("EncodingComboBoxModel.WARN_ENCODING_FILE_NOT_FOUND", encFile));
            } else {
                try {
                    Properties encDef = new Properties();
                    BufferedInputStream bin = new BufferedInputStream(in);
                    try {
                        encDef.load(bin);
                    }
                    finally {
                        bin.close();
                    }
                    Enumeration<Object> en = encDef.keys();
                    while (en.hasMoreElements()) {
                        String enc = (String)en.nextElement();
                        if (!"true".equalsIgnoreCase(encDef.getProperty(enc, "false"))) continue;
                        ecb.addEncoding(enc, ecb.getEncodingDescription(enc));
                    }
                }
                catch (IOException e) {
                    Messages messages = new Messages(locale, "org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.messages.messages", ObjectUtilities.getClassLoader(SwingCommonModule.class));
                    logger.warn((Object)(messages.getString("EncodingComboBoxModel.WARN_ERROR_READING_ENCODING_FILE") + encFile), (Throwable)e);
                }
            }
        }
        return ecb;
    }

    public int indexOf(String encoding) {
        return this.encodings.indexOf(new EncodingCarrier(encoding, null));
    }

    public String getEncoding(int index) {
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(index);
        return ec.getName();
    }

    public String getDescription(int index) {
        EncodingCarrier ec = (EncodingCarrier)this.encodings.get(index);
        return ec.getDescription();
    }

    public static String getEncodingsDefinitionFile() {
        return ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(ENCODINGS_DEFINITION_FILE, ENCODINGS_DEFINITION_FILE_DEFAULT);
    }

    public static String getAvailableEncodings() {
        return ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(AVAILABLE_ENCODINGS, AVAILABLE_ENCODINGS_ALL);
    }

    public void setSelectedEncoding(String encoding) {
        if (encoding == null) {
            this.selectedIndex = -1;
            this.selectedObject = null;
            return;
        }
        int size = this.encodings.size();
        for (int i = 0; i < size; ++i) {
            EncodingCarrier carrier = (EncodingCarrier)this.encodings.get(i);
            if (!encoding.equals(carrier.getName())) continue;
            this.selectedIndex = i;
            this.selectedObject = carrier.getDisplayName();
            this.fireContentsChanged(-1, -1);
            return;
        }
        if (size > 0) {
            this.selectedIndex = 0;
            this.selectedObject = this.getElementAt(0);
            this.fireContentsChanged(-1, -1);
        }
    }

    private static class EncodingCarrier {
        private String name;
        private String description;
        private String displayName;

        protected EncodingCarrier(String name, String description) {
            this.name = name;
            this.description = description;
            if (name == null) {
                this.displayName = null;
            } else {
                StringBuilder dName = new StringBuilder(100);
                dName.append(name);
                dName.append(" (");
                dName.append(description);
                dName.append(')');
                this.displayName = dName.toString();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EncodingCarrier)) {
                return false;
            }
            EncodingCarrier carrier = (EncodingCarrier)o;
            return !(this.name == null ? carrier.name != null : !this.name.equalsIgnoreCase(carrier.name));
        }

        public int hashCode() {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }
    }

    private static class EncodingCarrierComparator
    implements Comparator,
    Serializable {
        protected EncodingCarrierComparator() {
        }

        public int compare(Object o1, Object o2) {
            EncodingCarrier e1 = (EncodingCarrier)o1;
            EncodingCarrier e2 = (EncodingCarrier)o2;
            String name1 = e1.getName();
            String name2 = e2.getName();
            if (name1 == null && name2 == null) {
                return 0;
            }
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.toLowerCase().compareTo(name2.toLowerCase());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return this.getClass().equals(o.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

