/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class FileChooserService {
    private static FileChooserService service;
    private HashMap instances = new HashMap();

    public static synchronized FileChooserService getInstance() {
        if (service == null) {
            service = new FileChooserService();
        }
        return service;
    }

    public void flush() {
        this.instances.clear();
    }

    public File performOpen(Component parent, String title, FilesystemFilter[] rawFilter) {
        int result;
        File parentDir;
        FilterKey key = new FilterKey(rawFilter);
        JFileChooser fileChooser = new JFileChooser();
        FilesystemFilter[] filters = key.getFilters();
        for (int i = 0; i < filters.length; ++i) {
            FilesystemFilter filesystemFilter = filters[i];
            fileChooser.addChoosableFileFilter((FileFilter)filesystemFilter);
        }
        File o = (File)this.instances.get(key);
        if (o != null && (parentDir = o.getParentFile()) != null) {
            fileChooser.setCurrentDirectory(parentDir);
        }
        if ((result = fileChooser.showOpenDialog(parent)) == 0) {
            File resultFile = fileChooser.getSelectedFile();
            this.instances.put(key, resultFile);
            return resultFile;
        }
        return null;
    }

    public File performSave(Component parent, String title, FilesystemFilter[] rawFilter) {
        int result;
        File parentDir;
        FilterKey key = new FilterKey(rawFilter);
        JFileChooser fileChooser = new JFileChooser();
        FilesystemFilter[] filters = key.getFilters();
        for (int i = 0; i < filters.length; ++i) {
            FilesystemFilter filesystemFilter = filters[i];
            fileChooser.addChoosableFileFilter((FileFilter)filesystemFilter);
        }
        File o = (File)this.instances.get(key);
        if (o != null && (parentDir = o.getParentFile()) != null) {
            fileChooser.setCurrentDirectory(parentDir);
        }
        if ((result = fileChooser.showSaveDialog(parent)) == 0) {
            File resultFile = fileChooser.getSelectedFile();
            this.instances.put(key, resultFile);
            return resultFile;
        }
        return null;
    }

    private static class FilterKey {
        private FilesystemFilter[] filters;

        private FilterKey(FilesystemFilter[] filters) {
            this.filters = filters != null ? (FilesystemFilter[])filters.clone() : new FilesystemFilter[0];
        }

        public FilesystemFilter[] getFilters() {
            return (FilesystemFilter[])this.filters.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterKey filterKey = (FilterKey)o;
            return ObjectUtilities.equalArray((Object[])this.filters, (Object[])filterKey.filters);
        }

        public int hashCode() {
            return ObjectUtilities.hashCode((Object[])this.filters);
        }
    }
}

