/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.DefaultIconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;

public class JStatusBar
extends JComponent {
    public static final String STATUS_TYPE_PROPERTY = "statusType";
    public static final String STATUS_TEXT_PROPERTY = "statusText";
    public static final String ERROR_PROPERTY = "error";
    private JComponent otherComponents;
    private JLabel statusHolder;
    private IconTheme iconTheme;
    private StatusType statusType;

    public JStatusBar() {
        this(new DefaultIconTheme());
    }

    public JStatusBar(IconTheme theme) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        this.statusHolder.setMinimumSize(new Dimension(0, 20));
        this.add((Component)this.statusHolder, "Center");
        this.otherComponents = new JPanel();
        this.add((Component)this.otherComponents, "East");
        this.iconTheme = theme;
        this.statusType = StatusType.NONE;
    }

    protected IconTheme getIconTheme() {
        return this.iconTheme;
    }

    public void setIconTheme(IconTheme iconTheme) {
        IconTheme oldTheme = this.iconTheme;
        this.iconTheme = iconTheme;
        this.firePropertyChange("iconTheme", oldTheme, iconTheme);
        if (iconTheme == null) {
            this.statusHolder.setIcon(null);
        } else {
            this.updateTypeIcon(this.getStatusType());
        }
    }

    public JComponent getExtensionArea() {
        return this.otherComponents;
    }

    public StatusType getStatusType() {
        return this.statusType;
    }

    public String getStatusText() {
        return this.statusHolder.getText();
    }

    public void setStatusText(String text) {
        String oldText = this.statusHolder.getText();
        this.statusHolder.setText(text);
        this.firePropertyChange(STATUS_TEXT_PROPERTY, oldText, text);
    }

    public void setStatusType(StatusType type) {
        if (this.statusType == null) {
            throw new NullPointerException();
        }
        StatusType oldType = this.statusType;
        this.statusType = type;
        this.firePropertyChange(STATUS_TYPE_PROPERTY, oldType, type);
        this.updateTypeIcon(type);
    }

    public void setStatus(StatusType type, String text) {
        this.statusType = type;
        this.updateTypeIcon(type);
        this.statusHolder.setText(text);
    }

    private void updateTypeIcon(StatusType type) {
        if (this.iconTheme != null) {
            if (StatusType.ERROR.equals(type)) {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.errorIcon");
                this.statusHolder.setIcon(res);
            } else if (StatusType.WARNING.equals(type)) {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.warningIcon");
                this.statusHolder.setIcon(res);
            } else if (StatusType.INFORMATION.equals(type)) {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.informationIcon");
                this.statusHolder.setIcon(res);
            } else {
                Icon res = this.getIconTheme().getSmallIcon(this.getLocale(), "statusbar.otherIcon");
                this.statusHolder.setIcon(res);
            }
        }
    }

    public void clear() {
        this.setStatus(StatusType.NONE, " ");
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException ice) {
            return Locale.getDefault();
        }
    }
}

