/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing;

import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;

public class ReportProgressBar
extends JProgressBar
implements ReportProgressListener {
    private boolean onlyPagination;
    private final ScreenUpdateRunnable runnable = new ScreenUpdateRunnable();

    public ReportProgressBar() {
        super(0, 0, 100);
    }

    public boolean isOnlyPagination() {
        return this.onlyPagination;
    }

    public void setOnlyPagination(boolean onlyPagination) {
        this.onlyPagination = onlyPagination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProcessingStarted(ReportProgressEvent event) {
        ScreenUpdateRunnable screenUpdateRunnable = this.runnable;
        synchronized (screenUpdateRunnable) {
            if (this.runnable.update(event)) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.runnable.run();
                } else {
                    SwingUtilities.invokeLater(this.runnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProcessingUpdate(ReportProgressEvent event) {
        ScreenUpdateRunnable screenUpdateRunnable = this.runnable;
        synchronized (screenUpdateRunnable) {
            if (this.runnable.update(event)) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.runnable.run();
                } else {
                    SwingUtilities.invokeLater(this.runnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProcessingFinished(ReportProgressEvent event) {
        ScreenUpdateRunnable screenUpdateRunnable = this.runnable;
        synchronized (screenUpdateRunnable) {
            if (this.runnable.update(event)) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.runnable.run();
                } else {
                    SwingUtilities.invokeLater(this.runnable);
                }
            }
        }
    }

    private class ScreenUpdateRunnable
    implements Runnable {
        private ReportProgressEvent reportProgressEvent;

        protected ScreenUpdateRunnable() {
        }

        public ReportProgressEvent getReportProgressEvent() {
            return this.reportProgressEvent;
        }

        public void setReportProgressEvent(ReportProgressEvent reportProgressEvent) {
            this.reportProgressEvent = reportProgressEvent;
        }

        public synchronized void run() {
            if (this.reportProgressEvent == null) {
                return;
            }
            ReportProgressBar.this.setValue((int)ReportProgressEvent.computePercentageComplete(this.reportProgressEvent, ReportProgressBar.this.isOnlyPagination()));
            this.reportProgressEvent = null;
        }

        public boolean update(ReportProgressEvent event) {
            boolean retval = this.reportProgressEvent == null;
            this.reportProgressEvent = event;
            return retval;
        }
    }
}

