/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.action;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.action.AbstractActionDowngrade;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class AbstractFileSelectionAction
extends AbstractActionDowngrade {
    private JFileChooser fileChooser;
    private Component parent;

    protected AbstractFileSelectionAction(Component parent) {
        this.parent = parent;
    }

    protected abstract String getFileExtension();

    protected abstract String getFileDescription();

    protected File getCurrentDirectory() {
        return new File(".");
    }

    protected File performSelectFile(File selectedFile, int dialogType, boolean appendExtension) {
        if (this.fileChooser == null) {
            this.fileChooser = this.createFileChooser();
        }
        this.fileChooser.setSelectedFile(selectedFile);
        this.fileChooser.setDialogType(dialogType);
        int option = this.fileChooser.showDialog(this.parent, null);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)this.getFileExtension())) {
                selFileName = selFileName + this.getFileExtension();
            }
            return new File(selFileName);
        }
        return null;
    }

    protected JFileChooser createFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter((FileFilter)new FilesystemFilter(this.getFileExtension(), this.getFileDescription()));
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(this.getCurrentDirectory());
        return fc;
    }
}

