/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.csv.CSVDataExportPlugin;
import org.pentaho.reporting.engine.classic.core.modules.output.csv.CSVProcessor;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class CSVDataExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(CSVDataExportTask.class);
    private Messages messages;
    private final String fileName;
    private final MasterReport report;
    private ReportProgressDialog progressDialog;
    private StatusListener statusListener;

    public CSVDataExportTask(MasterReport report, ReportProgressDialog dialog, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException("CSVDataExportTask(..): Report parameter cannot be null");
        }
        String filename = report.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.FileName");
        if (filename == null) {
            throw new ReportProcessingException("CSVDataExportTask(..): Configuration does not contain a valid filename");
        }
        this.fileName = filename;
        this.report = report;
        this.progressDialog = dialog;
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.csv.messages.messages", ObjectUtilities.getClassLoader(CSVDataExportPlugin.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Writer out = null;
        File file = new File(this.fileName);
        try {
            File directory = file.getAbsoluteFile().getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                logger.warn((Object)"Can't create directories. Hoping and praying now..");
            }
            String encoding = this.report.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            CSVProcessor target = new CSVProcessor(this.report);
            if (this.progressDialog != null) {
                this.progressDialog.setModal(false);
                this.progressDialog.setVisible(true);
                target.addReportProgressListener(this.progressDialog);
            }
            target.setWriter(out);
            target.processReport();
            out.close();
            out = null;
            if (this.progressDialog != null) {
                target.removeReportProgressListener(this.progressDialog);
            }
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("CSVRawExportTask.USER_TASK_COMPLETE"), null);
            }
        }
        catch (ReportInterruptedException re) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("CSVRawExportTask.USER_TASK_ABORTED"), null);
            }
            try {
                out.close();
                out = null;
                if (!file.delete()) {
                    logger.warn((Object)("Unable to delete incomplete export:" + file));
                }
            }
            catch (SecurityException se) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        catch (Exception re) {
            logger.error((Object)"Exporting failed .", (Throwable)re);
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("CSVRawExportTask.USER_TASK_FAILED"), re);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                if (this.statusListener != null) {
                    this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("CSVRawExportTask.USER_TASK_FAILED"), e);
                }
                logger.error((Object)"Unable to close the output stream.", (Throwable)e);
            }
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
            }
        }
    }
}

