/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.csv;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.AbstractExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.EncodingComboBoxModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.LengthLimitingDocument;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.action.ActionButton;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class CSVTableExportDialog
extends AbstractExportDialog {
    public static final String CSV_OUTPUT_ENCODING_DEFAULT = EncodingRegistry.getPlatformDefaultEncoding();
    private JTextField txFilename;
    private JComboBox cbEncoding;
    private EncodingComboBoxModel encodingModel;
    private JCheckBox cbxStrictLayout;
    private JRadioButton rbSeparatorTab;
    private JRadioButton rbSeparatorColon;
    private JRadioButton rbSeparatorSemicolon;
    private JRadioButton rbSeparatorOther;
    private JTextField txSeparatorOther;
    private JStatusBar statusBar;
    private JFileChooser fileChooser;
    private static final String COMMA_SEPARATOR = ",";
    private static final String SEMICOLON_SEPARATOR = ";";
    private static final String TAB_SEPARATOR = "\t";
    private static final String CSV_FILE_EXTENSION = ".csv";

    public CSVTableExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public CSVTableExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public CSVTableExportDialog() {
        this.initConstructor();
    }

    private void initConstructor() {
        this.statusBar = new JStatusBar();
        this.setTitle(this.getResources().getString("csvexportdialog.dialogtitle"));
        this.initialize();
        this.clear();
        this.getFormValidator().setEnabled(true);
    }

    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    protected String getResourceBaseName() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.csv.messages.messages";
    }

    private void initialize() {
        this.rbSeparatorTab = new JRadioButton(this.getResources().getString("csvexportdialog.separator.tab"));
        this.rbSeparatorColon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.colon"));
        this.rbSeparatorSemicolon = new JRadioButton(this.getResources().getString("csvexportdialog.separator.semicolon"));
        this.rbSeparatorOther = new JRadioButton(this.getResources().getString("csvexportdialog.separator.other"));
        this.getFormValidator().registerButton(this.rbSeparatorColon);
        this.getFormValidator().registerButton(this.rbSeparatorOther);
        this.getFormValidator().registerButton(this.rbSeparatorSemicolon);
        this.getFormValidator().registerButton(this.rbSeparatorTab);
        ButtonGroup btg = new ButtonGroup();
        btg.add(this.rbSeparatorTab);
        btg.add(this.rbSeparatorColon);
        btg.add(this.rbSeparatorSemicolon);
        btg.add(this.rbSeparatorOther);
        ActionSelectSeparator selectAction = new ActionSelectSeparator();
        this.rbSeparatorTab.addActionListener(selectAction);
        this.rbSeparatorColon.addActionListener(selectAction);
        this.rbSeparatorSemicolon.addActionListener(selectAction);
        this.rbSeparatorOther.addActionListener(selectAction);
        this.txSeparatorOther = new JTextField();
        this.txSeparatorOther.setDocument(new LengthLimitingDocument(1));
        this.txSeparatorOther.setColumns(5);
        this.getFormValidator().registerTextField(this.txSeparatorOther);
        this.cbxStrictLayout = new JCheckBox(this.getResources().getString("csvexportdialog.strict-layout"));
        this.getFormValidator().registerButton(this.cbxStrictLayout);
        this.txFilename = new JTextField();
        this.txFilename.setColumns(30);
        this.encodingModel = EncodingComboBoxModel.createDefaultModel(Locale.getDefault());
        this.encodingModel.sort();
        this.cbEncoding = new JComboBox(this.encodingModel);
        JPanel exportPane = this.createExportPane();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(this.getResources().getString("csvexportdialog.export-settings"), exportPane);
        tabbedPane.add(this.getResources().getString("csvexportdialog.parameters"), this.getParametersPanel());
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.table.AdvancedSettingsAvailable"))) {
            JPanel advancedOptionsPane = this.createAdvancedOptionsPanel();
            tabbedPane.add(this.getResources().getString("csvexportdialog.advanced-settings"), advancedOptionsPane);
        }
        this.setContentPane(this.createContentPane(tabbedPane));
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerComboBox(this.cbEncoding);
    }

    private JPanel createExportPane() {
        JLabel lblFileName = new JLabel(this.getResources().getString("csvexportdialog.filename"));
        ActionButton btnSelect = new ActionButton(new ActionSelectFile(this.getResources()));
        JPanel exportPane = new JPanel();
        exportPane.setLayout(new GridBagLayout());
        exportPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 5);
        exportPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(3, 1, 5, 1);
        exportPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.insets = new Insets(1, 5, 5, 1);
        exportPane.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 1, 1, 1);
        exportPane.add((Component)new JPanel(), gbc);
        return exportPane;
    }

    private JPanel createAdvancedOptionsPanel() {
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        advancedOptionsPane.add((Component)this.createExportOptionsPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 1, 1, 1);
        advancedOptionsPane.add((Component)this.createSeparatorPanel(), gbc);
        return advancedOptionsPane;
    }

    private JPanel createExportOptionsPanel() {
        JPanel exportTypePanel = new JPanel();
        exportTypePanel.setLayout(new GridBagLayout());
        JLabel lblEncoding = new JLabel(this.getResources().getString("csvexportdialog.encoding"));
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.export-options"));
        exportTypePanel.setBorder(tb);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 5);
        exportTypePanel.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 1, 1, 1);
        exportTypePanel.add((Component)this.cbEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 1, 1, 1);
        exportTypePanel.add((Component)this.cbxStrictLayout, gbc);
        return exportTypePanel;
    }

    private JPanel createSeparatorPanel() {
        JPanel separatorPanel = new JPanel();
        separatorPanel.setLayout(new GridBagLayout());
        TitledBorder tb = new TitledBorder(this.getResources().getString("csvexportdialog.separatorchar"));
        separatorPanel.setBorder(tb);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorTab, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorColon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorSemicolon, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        separatorPanel.add((Component)this.rbSeparatorOther, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.ipadx = 20;
        separatorPanel.add((Component)this.txSeparatorOther, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        separatorPanel.add((Component)new JPanel(), gbc);
        return separatorPanel;
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    public void clear() {
        this.txFilename.setText("");
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(EncodingRegistry.getPlatformDefaultEncoding()));
        this.rbSeparatorColon.setSelected(true);
        this.cbxStrictLayout.setSelected(false);
        this.performSeparatorSelection();
    }

    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration config = new DefaultConfiguration();
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Separator", this.getSeparatorString());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Separator", this.getSeparatorString());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StrictLayout.StrictLayout", String.valueOf(this.isStrictLayout()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Encoding", this.getEncoding());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.FileName", this.getFilename());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.WriteStateColumns", "false");
        return config;
    }

    protected void setDialogContents(Configuration config) {
        String tableCSVSeparator = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.csv.Separator", COMMA_SEPARATOR);
        this.setSeparatorString(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Separator", tableCSVSeparator));
        String baseStrict = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.StrictLayout");
        String strict = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StrictLayout", baseStrict);
        this.setStrictLayout("true".equals(strict));
        String encoding = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Encoding", CSV_OUTPUT_ENCODING_DEFAULT);
        this.encodingModel.ensureEncodingAvailable(encoding);
        this.setEncoding(encoding);
        String defaultFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.FileName");
        if (defaultFileName != null) {
            this.setFilename(this.resolvePath(defaultFileName).getAbsolutePath());
        } else {
            this.setFilename("");
        }
    }

    public String getSeparatorString() {
        if (this.rbSeparatorColon.isSelected()) {
            return COMMA_SEPARATOR;
        }
        if (this.rbSeparatorSemicolon.isSelected()) {
            return SEMICOLON_SEPARATOR;
        }
        if (this.rbSeparatorTab.isSelected()) {
            return TAB_SEPARATOR;
        }
        if (this.rbSeparatorOther.isSelected()) {
            return this.txSeparatorOther.getText();
        }
        return "";
    }

    public void setSeparatorString(String s) {
        if (s == null) {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText("");
        } else if (s.equals(COMMA_SEPARATOR)) {
            this.rbSeparatorColon.setSelected(true);
        } else if (s.equals(SEMICOLON_SEPARATOR)) {
            this.rbSeparatorSemicolon.setSelected(true);
        } else if (s.equals(TAB_SEPARATOR)) {
            this.rbSeparatorTab.setSelected(true);
        } else {
            this.rbSeparatorOther.setSelected(true);
            this.txSeparatorOther.setText(s);
        }
        this.performSeparatorSelection();
    }

    public String getEncoding() {
        if (this.cbEncoding.getSelectedIndex() == -1) {
            return EncodingRegistry.getPlatformDefaultEncoding();
        }
        return this.encodingModel.getEncoding(this.cbEncoding.getSelectedIndex());
    }

    public void setEncoding(String encoding) {
        this.cbEncoding.setSelectedIndex(this.encodingModel.indexOf(encoding));
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(CSV_FILE_EXTENSION, this.getResources().getString("csvexportdialog.csv-file-description"));
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        this.fileChooser.setSelectedFile(new File(this.getFilename()));
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)CSV_FILE_EXTENSION)) {
                selFileName = selFileName + CSV_FILE_EXTENSION;
            }
            this.setFilename(selFileName);
        }
    }

    protected boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("csvexportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("csvexportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("csvexportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("csvexportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(StatusType.WARNING, message);
        }
        return true;
    }

    protected boolean performConfirm() {
        File f = new File(this.getFilename());
        if (f.exists()) {
            String key1 = "csvexportdialog.targetOverwriteConfirmation";
            String key2 = "csvexportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("csvexportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("csvexportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    protected void performSeparatorSelection() {
        if (this.rbSeparatorOther.isSelected()) {
            this.txSeparatorOther.setEnabled(true);
        } else {
            this.txSeparatorOther.setEnabled(false);
        }
    }

    public boolean isStrictLayout() {
        return this.cbxStrictLayout.isSelected();
    }

    public void setStrictLayout(boolean strictLayout) {
        this.cbxStrictLayout.setSelected(strictLayout);
    }

    protected String getConfigurationSuffix() {
        return "_csvexport";
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.csv.";
    }

    private class ActionSelectFile
    extends AbstractAction {
        protected ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("csvexportdialog.selectFile"));
        }

        public void actionPerformed(ActionEvent e) {
            CSVTableExportDialog.this.performSelectFile();
        }
    }

    private class ActionSelectSeparator
    extends AbstractAction {
        protected ActionSelectSeparator() {
        }

        public void actionPerformed(ActionEvent e) {
            CSVTableExportDialog.this.performSeparatorSelection();
        }
    }
}

