/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.csv;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.csv.CSVExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.csv.CSVTableExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class CSVTableExportPlugin
extends AbstractExportActionPlugin {
    private static final Log logger = LogFactory.getLog(CSVTableExportPlugin.class);
    public static final String BASE_RESOURCE_CLASS = "org.pentaho.reporting.engine.classic.core.modules.gui.csv.messages.messages";
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.csv.messages.messages", ObjectUtilities.getClassLoader(CSVTableExportPlugin.class));

    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(CSVExportGUIModule.class.getName());
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.csv.export.table.";
    }

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("cvs-export.progressdialog.message"));
        progressDialog.pack();
        SwingUtil.positionFrameRandomly(progressDialog);
        return progressDialog;
    }

    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        if (report == null) {
            throw new NullPointerException();
        }
        boolean result = this.performShowExportDialog(report, "org.pentaho.reporting.engine.classic.core.modules.gui.csv.table.Dialog");
        if (!result) {
            return false;
        }
        if (this.isProgressDialogEnabled(report, "org.pentaho.reporting.engine.classic.core.modules.gui.csv.table.ProgressDialogEnabled")) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        try {
            CSVTableExportTask task = new CSVTableExportTask(report, progressDialog, this.getContext());
            Thread worker = new Thread(task);
            worker.start();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Failure while preparing the CSV export", (Throwable)e);
            this.getContext().getStatusListener().setStatus(StatusType.ERROR, this.getResources().getString("CVSExportPlugin.ERROR_0001_FAILED"), e);
            return false;
        }
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-csv.table.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-csv.table.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.export-to-csv.table.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.export-to-csv.table.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.export-to-csv.table.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.export-to-csv.table.mnemonic");
    }
}

