/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.html;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.html.HtmlDirExportTask;
import org.pentaho.reporting.engine.classic.core.modules.gui.html.HtmlExportGUIModule;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class HtmlDirExportPlugin
extends AbstractExportActionPlugin {
    private static final Log logger = LogFactory.getLog(HtmlDirExportPlugin.class);
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));

    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(HtmlExportGUIModule.class.getName());
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.html.export.file.";
    }

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("html-export.progressdialog.message"));
        progressDialog.pack();
        SwingUtil.positionFrameRandomly(progressDialog);
        return progressDialog;
    }

    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        boolean result = this.performShowExportDialog(report, "org.pentaho.reporting.engine.classic.core.modules.gui.html.file.Dialog");
        if (!result) {
            return false;
        }
        if (this.isProgressDialogEnabled(report, "org.pentaho.reporting.engine.classic.core.modules.gui.html.file.ProgressDialogEnabled")) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        try {
            HtmlDirExportTask task = new HtmlDirExportTask(report, progressDialog, this.getContext());
            Thread worker = new Thread(task);
            worker.start();
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Failure while preparing the HTML export", (Throwable)e);
            this.getContext().getStatusListener().setStatus(StatusType.ERROR, this.resources.getString("HtmlDirExportPlugin.USER_FAILED"), e);
            return false;
        }
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-html.file.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-html.file.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.export-to-html.file.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.export-to-html.file.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.export-to-html.file.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.export-to-html.file.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }
}

