/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.html;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.html.HtmlExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FlowHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.PageableHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;

public class HtmlDirExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(HtmlDirExportTask.class);
    private Messages messages;
    private final ReportProgressDialog progressDialog;
    private File dataDirectory;
    private final MasterReport report;
    private StatusListener statusListener;
    private String exportMethod;
    private File targetDirectory;
    private String suffix;
    private String filename;

    public HtmlDirExportTask(MasterReport report, ReportProgressDialog progressDialog, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new ReportProcessingException("HtmlDirExportTask(..): Report-Parameter cannot be null");
        }
        this.progressDialog = progressDialog;
        this.report = report;
        Configuration config = report.getConfiguration();
        String dataDirectoryName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.file.DataDirectory");
        String targetFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.file.TargetFileName");
        this.exportMethod = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.file.ExportMethod");
        try {
            if (swingGuiContext != null) {
                this.statusListener = swingGuiContext.getStatusListener();
                this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));
            } else {
                this.messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));
            }
            File targetFile = new File(targetFileName).getCanonicalFile();
            this.targetDirectory = targetFile.getParentFile();
            File tempDataDir = new File(dataDirectoryName).getCanonicalFile();
            this.dataDirectory = !"".equals(dataDirectoryName) && tempDataDir.isAbsolute() ? tempDataDir : new File(this.targetDirectory, dataDirectoryName).getCanonicalFile();
            if (this.dataDirectory.exists() && !this.dataDirectory.isDirectory()) {
                this.dataDirectory = this.dataDirectory.getParentFile();
                if (!this.dataDirectory.isDirectory()) {
                    throw new ReportProcessingException("HtmlDirExportTask(..): Data-Directory is invalid: " + this.dataDirectory);
                }
            } else if (!this.dataDirectory.exists()) {
                this.dataDirectory.mkdirs();
            }
            this.suffix = this.getSuffix(targetFileName);
            this.filename = IOUtils.getInstance().stripFileExtension(targetFile.getName());
            if (targetFile.exists() && !targetFile.delete()) {
                throw new ReportProcessingException(this.messages.getErrorString("HtmlDirExportTask.ERROR_0003_TARGET_FILE_EXISTS", targetFile.getAbsolutePath()));
            }
        }
        catch (IOException ioe) {
            throw new ReportProcessingException("Failed to normalize directories.", ioe);
        }
    }

    private String getSuffix(String filename) {
        String suffix = IOUtils.getInstance().getFileExtension(filename);
        if (suffix.length() == 0) {
            return "";
        }
        return suffix.substring(1);
    }

    public void run() {
        block10: {
            try {
                AbstractReportProcessor sp;
                FileRepository targetRepository = new FileRepository(this.targetDirectory);
                ContentLocation targetRoot = targetRepository.getRoot();
                FileRepository dataRepository = new FileRepository(this.dataDirectory);
                ContentLocation dataRoot = dataRepository.getRoot();
                if ("pageable".equals(this.exportMethod)) {
                    PageableHtmlOutputProcessor outputProcessor = new PageableHtmlOutputProcessor(this.report.getConfiguration());
                    AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                    printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, this.filename, this.suffix));
                    printer.setDataWriter(dataRoot, (NameGenerator)new DefaultNameGenerator(dataRoot, "content"));
                    printer.setUrlRewriter(new FileSystemURLRewriter());
                    outputProcessor.setPrinter(printer);
                    sp = new PageableReportProcessor(this.report, outputProcessor);
                } else {
                    HtmlOutputProcessor outputProcessor = this.createOutputProcessor();
                    AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                    printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, this.filename, this.suffix));
                    printer.setDataWriter(dataRoot, (NameGenerator)new DefaultNameGenerator(dataRoot, "content"));
                    printer.setUrlRewriter(new FileSystemURLRewriter());
                    outputProcessor.setPrinter(printer);
                    sp = new FlowReportProcessor(this.report, outputProcessor);
                }
                if (this.progressDialog != null) {
                    this.progressDialog.setModal(false);
                    this.progressDialog.setVisible(true);
                    sp.addReportProgressListener(this.progressDialog);
                }
                sp.processReport();
                sp.close();
                if (this.progressDialog != null) {
                    sp.removeReportProgressListener(this.progressDialog);
                }
                if (this.statusListener != null) {
                    this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("HtmlDirExportTask.USER_TASK_FINISHED"), null);
                }
            }
            catch (ReportInterruptedException re) {
                if (this.statusListener != null) {
                    this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("HtmlDirExportTask.USER_TASK_ABORTED"), null);
                }
            }
            catch (Exception re) {
                logger.error((Object)"Exporting failed .", (Throwable)re);
                if (this.statusListener == null) break block10;
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("HtmlDirExportTask.USER_TASK_ERROR"), re);
            }
        }
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
    }

    protected HtmlOutputProcessor createOutputProcessor() {
        if ("pageable".equals(this.exportMethod)) {
            return new PageableHtmlOutputProcessor(this.report.getConfiguration());
        }
        if ("flow".equals(this.exportMethod)) {
            return new FlowHtmlOutputProcessor(this.report.getConfiguration());
        }
        return new StreamHtmlOutputProcessor(this.report.getConfiguration());
    }
}

