/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.html.HtmlExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FlowHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.PageableHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.SingleRepositoryURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class HtmlZipExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(HtmlZipExportTask.class);
    private Messages messages;
    private final ReportProgressDialog progressDialog;
    private final MasterReport report;
    private StatusListener statusListener;
    private String exportMethod;
    private String dataDirectory;
    private File targetFile;

    public HtmlZipExportTask(MasterReport report, ReportProgressDialog dialog, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new ReportProcessingException("HtmlZipExportTask(..): Report-Parameter cannot be null");
        }
        Configuration config = report.getConfiguration();
        this.dataDirectory = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.DataDirectory");
        String targetFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.TargetFileName");
        this.exportMethod = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.html.zip.ExportMethod");
        this.progressDialog = dialog;
        this.report = report;
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));
        } else {
            this.messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.html.messages.messages", ObjectUtilities.getClassLoader(HtmlExportGUIModule.class));
        }
        this.targetFile = new File(targetFileName);
        if (this.targetFile.exists() && !this.targetFile.delete()) {
            throw new ReportProcessingException(this.messages.getErrorString("HtmlZipExportTask.ERROR_0002_TARGET_FILE_EXISTS"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        OutputStream out = null;
        try {
            AbstractReportProcessor sp;
            out = new BufferedOutputStream(new FileOutputStream(this.targetFile));
            ZipRepository zipRepository = new ZipRepository(out);
            ContentLocation root = zipRepository.getRoot();
            ContentLocation data = RepositoryUtilities.createLocation((Repository)zipRepository, (String[])RepositoryUtilities.splitPath((String)this.dataDirectory, (String)"/"));
            if ("pageable".equals(this.exportMethod)) {
                PageableHtmlOutputProcessor outputProcessor = new PageableHtmlOutputProcessor(this.report.getConfiguration());
                AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                printer.setContentWriter(root, (NameGenerator)new DefaultNameGenerator(root, "report.html"));
                printer.setDataWriter(data, (NameGenerator)new DefaultNameGenerator(data, "content"));
                printer.setUrlRewriter(new SingleRepositoryURLRewriter());
                outputProcessor.setPrinter(printer);
                sp = new PageableReportProcessor(this.report, outputProcessor);
            } else {
                HtmlOutputProcessor outputProcessor = this.createOutputProcessor();
                AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(this.report.getResourceManager());
                printer.setContentWriter(root, (NameGenerator)new DefaultNameGenerator(root, "report.html"));
                printer.setDataWriter(data, (NameGenerator)new DefaultNameGenerator(data, "content"));
                printer.setUrlRewriter(new SingleRepositoryURLRewriter());
                outputProcessor.setPrinter(printer);
                sp = new FlowReportProcessor(this.report, outputProcessor);
            }
            if (this.progressDialog != null) {
                this.progressDialog.setModal(false);
                this.progressDialog.setVisible(true);
                sp.addReportProgressListener(this.progressDialog);
            }
            sp.processReport();
            sp.close();
            zipRepository.close();
            out.close();
            out = null;
            if (this.progressDialog != null) {
                sp.removeReportProgressListener(this.progressDialog);
            }
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("HtmlZipExportTask.USER_TASK_FINISHED"), null);
            }
        }
        catch (ReportInterruptedException re) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("HtmlZipExportTask.USER_TASK_ABORTED"), null);
            }
            try {
                out.close();
                out = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception re) {
            logger.error((Object)"Exporting failed .", (Throwable)re);
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("HtmlZipExportTask.USER_TASK_FAILED"), re);
            }
        }
        finally {
            block27: {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to close the output stream.", (Throwable)e);
                    if (this.statusListener == null) break block27;
                    this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("HtmlZipExportTask.USER_TASK_FAILED"), e);
                }
            }
        }
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
    }

    protected HtmlOutputProcessor createOutputProcessor() {
        if ("pageable".equals(this.exportMethod)) {
            return new PageableHtmlOutputProcessor(this.report.getConfiguration());
        }
        if ("flow".equals(this.exportMethod)) {
            return new FlowHtmlOutputProcessor(this.report.getConfiguration());
        }
        return new StreamHtmlOutputProcessor(this.report.getConfiguration());
    }
}

