/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.pdf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.pdf.PdfExportPlugin;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class PdfExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(PdfExportTask.class);
    private Messages messages;
    private MasterReport report;
    private ReportProgressDialog progressListener;
    private StatusListener statusListener;
    private File targetFile;

    public PdfExportTask(MasterReport report, ReportProgressDialog progressListener, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException("PdfExportTask(..): Report parameter cannot be null");
        }
        this.report = report;
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.pdf.messages.messages", ObjectUtilities.getClassLoader(PdfExportPlugin.class));
        } else {
            this.messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.pdf.messages.messages", ObjectUtilities.getClassLoader(PdfExportPlugin.class));
        }
        this.progressListener = progressListener;
        Configuration config = report.getConfiguration();
        String targetFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.pdf.TargetFileName");
        if (targetFileName == null) {
            throw new NullPointerException("TargetFileName must be set in the configuration.");
        }
        this.targetFile = new File(targetFileName);
        if (this.targetFile.exists() && !this.targetFile.delete()) {
            throw new ReportProcessingException(this.messages.getErrorString("PdfExportTask.ERROR_0001_TARGET_EXISTS"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AbstractReportProcessor proc = null;
        BufferedOutputStream fout = null;
        try {
            fout = new BufferedOutputStream(new FileOutputStream(this.targetFile));
            PdfOutputProcessor outputProcessor = new PdfOutputProcessor(this.report.getConfiguration(), fout, this.report.getResourceManager());
            proc = new PageableReportProcessor(this.report, outputProcessor);
            if (this.progressListener != null) {
                proc.addReportProgressListener(this.progressListener);
                this.progressListener.setVisible(true);
            }
            proc.processReport();
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("PdfExportTask.USER_EXPORT_COMPLETE"), null);
            }
        }
        catch (Exception e) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("PdfExportTask.USER_EXPORT_FAILED"), e);
            }
            logger.error((Object)"Failed");
        }
        finally {
            if (proc != null) {
                if (this.progressListener != null) {
                    proc.removeReportProgressListener(this.progressListener);
                }
                proc.close();
            }
            if (fout != null) {
                try {
                    ((OutputStream)fout).close();
                }
                catch (IOException iOException) {}
            }
            if (this.progressListener != null) {
                this.progressListener.setVisible(false);
            }
        }
    }
}

