/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.plaintext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.EncodingComboBoxModel;
import org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.PlainTextExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterEncoding;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecification;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class EncodingSelector
extends JPanel {
    private static final Messages MESSAGES = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.messages.messages", ObjectUtilities.getClassLoader(PlainTextExportGUIModule.class));
    private EncodingComboBoxModel encodingComboBoxModel;
    private JComboBox encodingComboBox;

    public EncodingSelector() {
        this.setLayout(new BorderLayout());
        this.encodingComboBox = new JComboBox();
        this.add((Component)this.encodingComboBox, "Center");
        this.setEncodings(new GenericPrinterSpecification(), Locale.getDefault());
    }

    public String getSelectedEncoding() {
        return this.encodingComboBoxModel.getSelectedEncoding();
    }

    public void setSelectedEncoding(String encoding) {
        this.encodingComboBoxModel.setSelectedEncoding(encoding);
    }

    public void setEncodings(PrinterSpecification printerSpecification, Locale locale) {
        if (printerSpecification == null) {
            throw new NullPointerException(MESSAGES.getErrorString("EncodingSelector.ERROR_0002_NULL_SPECIFICATION"));
        }
        EncodingComboBoxModel defaultEncodingModel = EncodingComboBoxModel.createDefaultModel(locale);
        EncodingComboBoxModel retval = new EncodingComboBoxModel(locale);
        for (int i = 0; i < defaultEncodingModel.getSize(); ++i) {
            String encoding = defaultEncodingModel.getEncoding(i);
            if (!printerSpecification.isEncodingSupported(encoding)) continue;
            String description = defaultEncodingModel.getDescription(i);
            retval.addEncoding(encoding, description);
        }
        retval.sort();
        Object oldSelectedValue = this.encodingComboBox.getSelectedItem();
        this.encodingComboBox.setModel(retval);
        this.encodingComboBoxModel = retval;
        this.encodingComboBoxModel.setSelectedItem(oldSelectedValue);
    }

    public static class GenericPrinterSpecification
    implements PrinterSpecification {
        private static final byte[] EMPTY_ARRAY = new byte[0];

        public String getDisplayName() {
            return this.getName();
        }

        public PrinterEncoding getEncoding(String encoding) {
            if (!this.isEncodingSupported(encoding)) {
                throw new IllegalArgumentException(MESSAGES.getErrorString("EncodingSelector.ERROR_0001_ENCODING_NOT_SUPPORTED"));
            }
            return new PrinterEncoding(encoding, encoding, encoding, EMPTY_ARRAY);
        }

        public String getName() {
            return MESSAGES.getString("EncodingSelector.USER_GENERIC_PRINTER");
        }

        public boolean isEncodingSupported(String encoding) {
            return EncodingRegistry.getInstance().isSupportedEncoding(encoding);
        }

        public boolean isFeatureAvailable(String operationName) {
            return true;
        }
    }
}

