/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.plaintext;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.PlainTextExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.PlainTextExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class PlainTextExportPlugin
extends AbstractExportActionPlugin {
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.messages.messages", ObjectUtilities.getClassLoader(PlainTextExportGUIModule.class));
    public static final String BASE_RESOURCE_CLASS = "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.messages.messages";

    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(PlainTextExportGUIModule.class.getName());
    }

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("plaintext-export.progressdialog.message"));
        progressDialog.pack();
        SwingUtil.positionFrameRandomly(progressDialog);
        return progressDialog;
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.export.";
    }

    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        boolean result = this.performShowExportDialog(report, "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.Dialog");
        if (!result) {
            return false;
        }
        if (this.isProgressDialogEnabled(report, "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.ProgressDialogEnabled")) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        PlainTextExportTask task = new PlainTextExportTask(report, progressDialog, this.getContext());
        Thread thread = new Thread(task);
        thread.start();
        return true;
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-plaintext.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-plaintext.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.export-to-plaintext.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.export-to-plaintext.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.export-to-plaintext.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.export-to-plaintext.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }
}

