/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.plaintext;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.PlainTextExportPlugin;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PageableTextOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.AbstractEpsonPrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.Epson24PinPrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.Epson9PinPrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.IBMCompatiblePrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.TextFilePrinterDriver;
import org.pentaho.reporting.engine.classic.core.util.StringUtil;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class PlainTextExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(PlainTextExportTask.class);
    private Messages messages;
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final MasterReport report;
    private final int exportType;
    private final float charPerInch;
    private final float linesPerInch;
    private String printer;
    private StatusListener statusListener;

    public PlainTextExportTask(MasterReport report, ReportProgressDialog dialog, SwingGuiContext swingGuiContext) {
        if (report == null) {
            throw new NullPointerException("PlainTextExportTask(): Report parameter must not be null");
        }
        Configuration config = report.getConfiguration();
        this.fileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.FileName");
        String selectedPrinterText = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.ExportType");
        if ("9pin".equals(selectedPrinterText)) {
            this.exportType = 1;
            this.printer = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.9PinPrinterType");
        } else if ("24pin".equals(selectedPrinterText)) {
            this.exportType = 3;
            this.printer = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.24PinPrinterType");
        } else if ("ibm".equals(selectedPrinterText)) {
            this.exportType = 2;
            this.printer = null;
        } else {
            this.exportType = 0;
            this.printer = null;
        }
        this.progressDialog = dialog;
        this.report = report;
        this.charPerInch = StringUtil.parseFloat(report.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch"), 10.0f);
        this.linesPerInch = StringUtil.parseFloat(report.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch"), 6.0f);
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.messages.messages", ObjectUtilities.getClassLoader(PlainTextExportPlugin.class));
        }
    }

    protected PrinterDriver getPrinterCommandSet(OutputStream out) {
        switch (this.exportType) {
            case 0: {
                return new TextFilePrinterDriver(out, this.charPerInch, this.linesPerInch);
            }
            case 2: {
                return new IBMCompatiblePrinterDriver(out, this.charPerInch, this.linesPerInch);
            }
            case 1: {
                Epson9PinPrinterDriver driver = new Epson9PinPrinterDriver(out, this.charPerInch, this.linesPerInch, this.printer);
                this.applyFallbackEncoding(driver);
                return driver;
            }
            case 3: {
                Epson24PinPrinterDriver driver = new Epson24PinPrinterDriver(out, this.charPerInch, this.linesPerInch, this.printer);
                this.applyFallbackEncoding(driver);
                return driver;
            }
        }
        throw new IllegalArgumentException();
    }

    private void applyFallbackEncoding(AbstractEpsonPrinterDriver driver) {
        String encoding = this.report.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.FallbackEncoding");
        driver.setFallBackCharset((byte)StringUtil.parseInt(encoding, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AbstractReportProcessor proc = null;
        OutputStream out = null;
        File file = null;
        try {
            file = new File(this.fileName).getCanonicalFile();
            File directory = file.getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                logger.warn((Object)"Can't create directories. Hoping and praying now..");
            }
            out = new BufferedOutputStream(new FileOutputStream(file));
            PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor(this.getPrinterCommandSet(out), this.report.getConfiguration());
            proc = new PageableReportProcessor(this.report, outputProcessor);
            if (this.progressDialog != null) {
                this.progressDialog.setModal(false);
                this.progressDialog.setVisible(true);
                proc.addReportProgressListener(this.progressDialog);
            }
            proc.processReport();
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("PlainTextExportTask.USER_TASK_FINISHED"), null);
            }
        }
        catch (ReportInterruptedException re) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.WARNING, this.messages.getString("PlainTextExportTask.USER_TASK_ABORTED"), null);
            }
            try {
                out.close();
                out = null;
                if (!file.delete()) {
                    logger.warn((Object)("Unable to delete incomplete export:" + file));
                }
            }
            catch (SecurityException se) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        catch (Exception re) {
            logger.error((Object)"PlainText export failed", (Throwable)re);
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("PlainTextExportTask.USER_TASK_FAILED"), re);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close the output stream.", (Throwable)e);
            }
            if (this.progressDialog != null) {
                proc.removeReportProgressListener(this.progressDialog);
            }
        }
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
    }
}

