/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.swing.JPanel;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PageBackgroundDrawable;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.DrawablePanel;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;

public class PageFormatPreviewPane
extends JPanel {
    private SimplePageDefinition pageDefinition;
    private DrawablePanel drawablePanel = new DrawablePanel();
    private static final RenderNode[] EMPTY_NODES = new RenderNode[0];
    private PageBackgroundDrawable pageBackgroundDrawable = new AutoScalePageBackgroundDrawable();

    public PageFormatPreviewPane() {
        this.pageBackgroundDrawable.setBackend(new SimplePageDrawable());
        this.setLayout(new BorderLayout());
        this.add(this.drawablePanel);
    }

    public SimplePageDefinition getPageDefinition() {
        return this.pageDefinition;
    }

    public void setPageDefinition(SimplePageDefinition pageDefinition) {
        this.pageDefinition = pageDefinition;
        if (pageDefinition != null) {
            this.drawablePanel.setDrawableAsRawObject(this.pageBackgroundDrawable);
        } else {
            this.drawablePanel.setDrawableAsRawObject(null);
        }
        this.repaint();
    }

    protected class AutoScalePageBackgroundDrawable
    extends PageBackgroundDrawable {
        protected AutoScalePageBackgroundDrawable() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 0);
        }

        public void draw(Graphics2D g2, Rectangle2D area) {
            this.setZoom(1.0);
            Dimension preferredSize = super.getPreferredSize();
            double scaleX = area.getWidth() / preferredSize.getWidth();
            double scaleY = area.getHeight() / preferredSize.getHeight();
            this.setZoom(Math.min(scaleX, scaleY));
            super.draw(g2, area);
        }
    }

    protected class SimplePageDrawable
    implements PageDrawable {
        public PageFormat getPageFormat() {
            if (PageFormatPreviewPane.this.pageDefinition == null) {
                return new PageFormat();
            }
            PageFormat pageFormat = PageFormatPreviewPane.this.pageDefinition.getPageFormat();
            Paper orgPaper = pageFormat.getPaper();
            PageFormatFactory pff = PageFormatFactory.getInstance();
            double virtualPaperWidth = orgPaper.getImageableWidth() + pff.getLeftBorder(orgPaper) + pff.getRightBorder(orgPaper);
            double virtualPaperHeight = orgPaper.getImageableHeight() + pff.getTopBorder(orgPaper) + pff.getBottomBorder(orgPaper);
            Paper p = pff.createPaper(virtualPaperWidth, virtualPaperHeight);
            pff.setBorders(p, pff.getTopBorder(orgPaper), pff.getLeftBorder(orgPaper), pff.getBottomBorder(orgPaper), pff.getRightBorder(orgPaper));
            return pff.createPageFormat(p, pageFormat.getOrientation());
        }

        public Dimension getPreferredSize() {
            if (PageFormatPreviewPane.this.pageDefinition == null) {
                return new Dimension();
            }
            PageFormat pageFormat = this.getPageFormat();
            return new Dimension((int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        }

        public void draw(Graphics2D graphics, Rectangle2D bounds) {
            PageFormat gpf = this.getPageFormat();
            Rectangle2D.Double imageableArea = new Rectangle2D.Double(gpf.getImageableX(), gpf.getImageableY(), gpf.getImageableWidth(), gpf.getImageableHeight());
            graphics.setPaint(new Color(225, 225, 225));
            graphics.fill(imageableArea);
            graphics.setPaint(Color.gray);
            graphics.draw(imageableArea);
            int pcH = PageFormatPreviewPane.this.pageDefinition.getPageCountHorizontal();
            int pcW = PageFormatPreviewPane.this.pageDefinition.getPageCountVertical();
            Line2D.Double line = new Line2D.Double();
            for (int splitH = 1; splitH < pcH; ++splitH) {
                double xPos = gpf.getImageableX() + (double)splitH * gpf.getImageableWidth();
                ((Line2D)line).setLine(xPos, gpf.getImageableY(), xPos, gpf.getImageableY() + gpf.getImageableHeight());
                graphics.draw(line);
            }
            for (int splitW = 1; splitW < pcW; ++splitW) {
                double yPos = gpf.getImageableY() + (double)splitW * gpf.getImageableHeight();
                ((Line2D)line).setLine(gpf.getImageableX(), yPos, gpf.getImageableX() + gpf.getImageableWidth(), yPos);
                graphics.draw(line);
            }
        }

        public RenderNode[] getNodesAt(double x, double y, String namespace, String name) {
            return EMPTY_NODES;
        }

        public RenderNode[] getNodesAt(double x, double y, double width, double height, String namespace, String name) {
            return EMPTY_NODES;
        }
    }
}

