/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.print;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.actions.ControlActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.GuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportEventSource;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.AWTPrintingGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PageSetupDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PrintingPlugin;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class PageSetupPlugin
extends AbstractActionPlugin
implements ControlActionPlugin {
    private ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.print.messages.messages", ObjectUtilities.getClassLoader(PrintingPlugin.class));
    private ReportEventSource eventSource;
    private ReportJobListener reportJobListener = new ReportJobListener();

    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        this.eventSource = context.getEventSource();
        this.eventSource.addPropertyChangeListener("reportJob", this.reportJobListener);
        this.setEnabled(this.eventSource.getReportJob() != null);
        return ClassicEngineBoot.getInstance().isModuleAvailable(AWTPrintingGUIModule.class.getName());
    }

    public void deinitialize(SwingGuiContext swingGuiContext) {
        super.deinitialize(swingGuiContext);
        swingGuiContext.getEventSource().removePropertyChangeListener("reportJob", this.reportJobListener);
    }

    public String getDisplayName() {
        return this.resources.getString("action.page-setup.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.page-setup.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.page-setup.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.page-setup.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return null;
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.page-setup.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.print.page-setup.";
    }

    public boolean configure(PreviewPane pane) {
        PageFormat original;
        MasterReport report = pane.getReportJob();
        if ("true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.print.UseAlternatePageSetupDialog"))) {
            Window proxy = this.getContext().getWindow();
            PageSetupDialog dialog = proxy instanceof Frame ? new PageSetupDialog((GuiContext)this.getContext(), (Frame)proxy) : (proxy instanceof Dialog ? new PageSetupDialog((GuiContext)this.getContext(), (Dialog)proxy) : new PageSetupDialog(this.getContext()));
            dialog.pack();
            SwingUtil.centerDialogInParent(dialog);
            PageDefinition definition = dialog.performSetup(report.getPageDefinition());
            if (!dialog.isConfirmed()) {
                return false;
            }
            report.setPageDefinition(definition);
            pane.setReportJob(report);
            return true;
        }
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = pj.validatePage(pj.pageDialog(original = report.getPageDefinition().getPageFormat(0)));
        if (PageFormatFactory.isEqual(pf, original)) {
            return false;
        }
        PageDefinition pageDefinition = report.getPageDefinition();
        if (pageDefinition instanceof SimplePageDefinition) {
            SimplePageDefinition spd = (SimplePageDefinition)pageDefinition;
            report.setPageDefinition(new SimplePageDefinition(pf, spd.getPageCountHorizontal(), spd.getPageCountVertical()));
        } else {
            report.setPageDefinition(new SimplePageDefinition(pf));
        }
        pane.setReportJob(report);
        return true;
    }

    private class ReportJobListener
    implements PropertyChangeListener {
        protected ReportJobListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PageSetupPlugin.this.setEnabled(PageSetupPlugin.this.eventSource.getReportJob() != null);
        }
    }
}

