/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.print;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.AWTPrintingGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PrintExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class PrintingPlugin
extends AbstractExportActionPlugin {
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.print.messages.messages", ObjectUtilities.getClassLoader(PrintingPlugin.class));
    public static final String BASE_RESOURCE_CLASS = "org.pentaho.reporting.engine.classic.core.modules.gui.print.messages.messages";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.print.ProgressDialogEnabled";

    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(AWTPrintingGUIModule.class.getName());
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("printing-export.progressdialog.message"));
        progressDialog.pack();
        SwingUtil.positionFrameRandomly(progressDialog);
        return progressDialog;
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.print.print.";
    }

    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        if ("true".equals(report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false"))) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        PrintExportTask task = new PrintExportTask(report, progressDialog, this.getContext());
        Thread worker = new Thread(task);
        worker.start();
        return true;
    }

    public String getDisplayName() {
        return this.resources.getString("action.print.name");
    }

    public String getShortDescription() {
        return this.resources.getString("action.print.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.print.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.print.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.print.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.print.mnemonic");
    }
}

