/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.rtf;

import java.util.Locale;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.AbstractExportActionPlugin;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingUtil;
import org.pentaho.reporting.engine.classic.core.modules.gui.rtf.RTFExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.gui.rtf.RTFExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class RTFExportPlugin
extends AbstractExportActionPlugin {
    private final ResourceBundleSupport resources = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.messages.messages", ObjectUtilities.getClassLoader(RTFExportPlugin.class));
    public static final String BASE_RESOURCE_CLASS = "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.messages.messages";

    public boolean initialize(SwingGuiContext context) {
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(RTFExportGUIModule.class.getName());
    }

    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.export.";
    }

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setMessage(this.resources.getString("rtf-export.progressdialog.message"));
        progressDialog.pack();
        SwingUtil.positionFrameRandomly(progressDialog);
        return progressDialog;
    }

    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        boolean result = this.performShowExportDialog(report, "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.Dialog");
        if (!result) {
            return false;
        }
        if (this.isProgressDialogEnabled(report, "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.ProgressDialogEnabled")) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        try {
            RTFExportTask task = new RTFExportTask(report, progressDialog, this.getContext());
            Thread worker = new Thread(task);
            worker.start();
            return true;
        }
        catch (Exception e) {
            this.getContext().getStatusListener().setStatus(StatusType.ERROR, this.resources.getString("RTFExportPlugin.USER_FAILED"), e);
            return false;
        }
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-rtf.description");
    }

    public Icon getSmallIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getSmallIcon(locale, "action.export-to-rtf.small-icon");
    }

    public Icon getLargeIcon() {
        Locale locale = this.getContext().getLocale();
        return this.getIconTheme().getLargeIcon(locale, "action.export-to-rtf.icon");
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getOptionalKeyStroke("action.export-to-rtf.accelerator");
    }

    public Integer getMnemonicKey() {
        return this.resources.getOptionalMnemonic("action.export-to-rtf.mnemonic");
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-rtf.name");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }
}

