/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.bsf;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.WrapperExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.states.LegacyDataRowWrapper;

public class BSFExpression
extends AbstractExpression {
    private static final Log logger = LogFactory.getLog(BSFExpression.class);
    private transient BSFManager interpreter;
    private transient boolean invalid;
    private transient LegacyDataRowWrapper dataRowWrapper;
    private transient WrapperExpressionRuntime runtimeWrapper;
    private String language;
    private String script;
    private String expression;

    protected BSFManager createInterpreter() {
        try {
            BSFManager interpreter = new BSFManager();
            this.initializeInterpreter(interpreter);
            return interpreter;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to initialize the expression", (Throwable)e);
            return null;
        }
    }

    protected void initializeInterpreter(BSFManager interpreter) throws BSFException {
        this.dataRowWrapper = new LegacyDataRowWrapper();
        this.runtimeWrapper = new WrapperExpressionRuntime();
        this.runtimeWrapper.update(this.getDataRow(), this.getRuntime());
        interpreter.declareBean("runtime", (Object)this.runtimeWrapper, ExpressionRuntime.class);
        interpreter.declareBean("dataRow", (Object)this.dataRowWrapper, DataRow.class);
        if (this.script != null) {
            interpreter.exec(this.getLanguage(), "script", 1, 1, (Object)this.getScript());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        if (this.invalid || this.expression == null) {
            return null;
        }
        if (this.interpreter == null) {
            this.interpreter = this.createInterpreter();
            if (this.interpreter == null) {
                this.invalid = true;
                return null;
            }
        }
        try {
            this.runtimeWrapper.update(null, this.getRuntime());
            this.dataRowWrapper.setParent(this.getDataRow());
            Object object = this.interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.getExpression());
            return object;
        }
        catch (Exception e) {
            logger.warn((Object)("Evaluation error: " + e.getClass() + " - " + e.getMessage()), (Throwable)e);
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            this.runtimeWrapper.update(null, null);
            this.dataRowWrapper.setParent(null);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BSFExpression expression = (BSFExpression)super.clone();
        expression.interpreter = null;
        return expression;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String getExpression() {
        return this.expression;
    }

    protected void invalidate() {
        this.interpreter = null;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.interpreter = null;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        this.interpreter = null;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
        this.interpreter = null;
    }
}

