/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.bsf;

import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;

public class BSFReportPreProcessor
implements ReportPreProcessor {
    private String script;
    private String language;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (this.script == null || this.language == null) {
            return definition;
        }
        try {
            BSFManager interpreter = new BSFManager();
            interpreter.declareBean("definition", (Object)definition, MasterReport.class);
            interpreter.declareBean("flowController", (Object)flowController, DefaultFlowController.class);
            Object o = interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.script);
            if (!(o instanceof MasterReport)) {
                throw new ReportDataFactoryException("Not a MasterReport");
            }
            return (MasterReport)o;
        }
        catch (BSFException e) {
            throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", e);
        }
    }

    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (this.script == null || this.language == null) {
            return definition;
        }
        try {
            BSFManager interpreter = new BSFManager();
            interpreter.declareBean("definition", (Object)definition, SubReport.class);
            interpreter.declareBean("flowController", (Object)flowController, DefaultFlowController.class);
            Object o = interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.script);
            if (!(o instanceof SubReport)) {
                throw new ReportDataFactoryException("Not a MasterReport");
            }
            return (SubReport)o;
        }
        catch (BSFException e) {
            throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", e);
        }
    }
}

