/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.configstore.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStorage;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStoreException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;

public class FileConfigStorage
implements ConfigStorage {
    private final File baseDirectory;
    private static final String CONFIGHEADER = "part of the Pentaho Reporting filesystem config store";

    public FileConfigStorage(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String configPath, Configuration config) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        Enumeration keys = config.getConfigProperties();
        Properties properties = new Properties();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = config.getConfigProperty(key);
            if (value == null || key == null) continue;
            properties.setProperty(key, value);
        }
        File target = new File(this.baseDirectory, configPath);
        if (target.exists() && !target.canWrite()) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
            try {
                properties.store(out, CONFIGHEADER);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            throw new ConfigStoreException("Failed to write config " + configPath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration load(String configPath, Configuration defaults) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The given path is not valid.");
        }
        try {
            Properties properties = new Properties();
            File target = new File(this.baseDirectory, configPath);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(target));
            try {
                properties.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
            HierarchicalConfiguration config = new HierarchicalConfiguration(defaults);
            for (String string : properties.keySet()) {
                config.setConfigProperty(string, properties.getProperty(string));
            }
            return config;
        }
        catch (Exception e) {
            throw new ConfigStoreException("Failed to read config" + configPath, e);
        }
    }

    public boolean isAvailable(String configPath) {
        if (!ConfigFactory.isValidPath(configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        File target = new File(this.baseDirectory, configPath);
        return target.exists() && target.canRead();
    }

    public String toString() {
        return "FileConfigStorage={baseDir=" + this.baseDirectory + '}';
    }
}

