/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory;

import java.util.HashMap;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.StaticDataFactory;

public class NamedStaticDataFactory
extends StaticDataFactory {
    private HashMap<String, String> querymappings = new HashMap();

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.querymappings.containsKey(query);
    }

    public void setQuery(String alias, String queryString) {
        if (queryString == null) {
            this.querymappings.remove(alias);
        } else {
            this.querymappings.put(alias, queryString);
        }
    }

    public DataFactory derive() {
        return (DataFactory)this.clone();
    }

    public Object clone() {
        NamedStaticDataFactory nds = (NamedStaticDataFactory)super.clone();
        nds.querymappings = (HashMap)this.querymappings.clone();
        return nds;
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        if (query == null) {
            throw new NullPointerException("Query is null.");
        }
        String realQuery = this.getQuery(query);
        if (realQuery == null) {
            throw new ReportDataFactoryException("Query '" + query + "' is not recognized.");
        }
        return super.queryData(realQuery, parameters);
    }

    public String getQuery(String name) {
        return this.querymappings.get(name);
    }

    public String[] getQueryNames() {
        return this.querymappings.keySet().toArray(new String[this.querymappings.size()]);
    }

    public String translateQuery(String queryName) {
        return this.querymappings.get(queryName);
    }
}

