/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class StaticDataFactory
implements DataFactory,
Cloneable {
    private static final String[] EMPTY_NAMES = new String[0];
    private static final String[] EMPTY_PARAMS = EMPTY_NAMES;

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return true;
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        int methodSeparatorIdx = query.indexOf(35);
        if (methodSeparatorIdx + 1 >= query.length()) {
            throw new ReportDataFactoryException("Malformed query: " + query);
        }
        if (methodSeparatorIdx == -1) {
            String constructorName;
            String[] parameterNames;
            int parameterStartIdx = query.indexOf(40);
            if (parameterStartIdx == -1) {
                parameterNames = EMPTY_PARAMS;
                constructorName = query;
            } else {
                parameterNames = this.createParameterList(query, parameterStartIdx);
                constructorName = query.substring(0, parameterStartIdx);
            }
            try {
                Constructor c = this.findDirectConstructor(constructorName, parameterNames.length);
                Object[] params = new Object[parameterNames.length];
                for (int i = 0; i < parameterNames.length; ++i) {
                    String name = parameterNames[i];
                    params[i] = parameters.get(name);
                }
                return (TableModel)c.newInstance(params);
            }
            catch (Exception e) {
                throw new ReportDataFactoryException("Unable to instantiate class for non static call.", (Throwable)e);
            }
        }
        return this.createComplexTableModel(query, methodSeparatorIdx, parameters);
    }

    public String[] getParameterFields(String query) throws ReportDataFactoryException {
        int methodSeparatorIdx = query.indexOf(35);
        if (methodSeparatorIdx + 1 >= query.length()) {
            return null;
        }
        if (methodSeparatorIdx == -1) {
            int parameterStartIdx = query.indexOf(40);
            if (parameterStartIdx == -1) {
                return EMPTY_PARAMS;
            }
            String[] list = this.createParameterList(query, parameterStartIdx);
            LinkedHashSet<String> hashSet = new LinkedHashSet<String>(Arrays.asList(list));
            return hashSet.toArray(new String[hashSet.size()]);
        }
        String constructorSpec = query.substring(0, methodSeparatorIdx);
        int constParamIdx = constructorSpec.indexOf(40);
        if (constParamIdx == -1) {
            String methodSpec = query.substring(methodSeparatorIdx + 1);
            int parameterStartIdx = methodSpec.indexOf(40);
            if (parameterStartIdx == -1) {
                return EMPTY_PARAMS;
            }
            String[] list = this.createParameterList(methodSpec, parameterStartIdx);
            LinkedHashSet<String> hashSet = new LinkedHashSet<String>(Arrays.asList(list));
            return hashSet.toArray(new String[hashSet.size()]);
        }
        String[] constructorParameterNames = this.createParameterList(constructorSpec, constParamIdx);
        LinkedHashSet<String> hashSet = new LinkedHashSet<String>();
        hashSet.addAll(Arrays.asList(constructorParameterNames));
        String methodQuery = query.substring(methodSeparatorIdx + 1);
        int parameterStartIdx = methodQuery.indexOf(40);
        if (parameterStartIdx != -1) {
            String[] list = this.createParameterList(methodQuery, parameterStartIdx);
            hashSet.addAll(Arrays.asList(list));
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private TableModel createComplexTableModel(String query, int methodSeparatorIdx, DataRow parameters) throws ReportDataFactoryException {
        String methodName;
        String[] methodParameterNames;
        String constructorSpec = query.substring(0, methodSeparatorIdx);
        int constParamIdx = constructorSpec.indexOf(40);
        if (constParamIdx == -1) {
            return this.loadFromDefaultConstructor(query, methodSeparatorIdx, parameters);
        }
        String className = query.substring(0, constParamIdx);
        String[] parameterNames = this.createParameterList(constructorSpec, constParamIdx);
        Constructor c = this.findIndirectConstructor(className, parameterNames.length);
        String methodQuery = query.substring(methodSeparatorIdx + 1);
        int parameterStartIdx = methodQuery.indexOf(40);
        if (parameterStartIdx == -1) {
            methodParameterNames = EMPTY_PARAMS;
            methodName = methodQuery;
        } else {
            methodName = methodQuery.substring(0, parameterStartIdx);
            methodParameterNames = this.createParameterList(methodQuery, parameterStartIdx);
        }
        Method m = this.findCallableMethod(className.trim(), methodName.trim(), methodParameterNames.length);
        try {
            Object[] constrParams = new Object[parameterNames.length];
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i];
                constrParams[i] = parameters.get(name);
            }
            Object o = c.newInstance(constrParams);
            Object[] methodParams = new Object[methodParameterNames.length];
            for (int i = 0; i < methodParameterNames.length; ++i) {
                String name = methodParameterNames[i];
                methodParams[i] = parameters.get(name);
            }
            Object data = m.invoke(o, methodParams);
            if (data == null) {
                throw new ReportDataFactoryException("The call did not return a valid tablemodel.");
            }
            return (TableModel)data;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Unable to instantiate class for non static call.");
        }
    }

    private TableModel loadFromDefaultConstructor(String query, int methodSeparatorIdx, DataRow parameters) throws ReportDataFactoryException {
        String methodName;
        String[] parameterNames;
        String className = query.substring(0, methodSeparatorIdx);
        String methodSpec = query.substring(methodSeparatorIdx + 1);
        int parameterStartIdx = methodSpec.indexOf(40);
        if (parameterStartIdx == -1) {
            parameterNames = EMPTY_PARAMS;
            methodName = methodSpec;
        } else {
            parameterNames = this.createParameterList(methodSpec, parameterStartIdx);
            methodName = methodSpec.substring(0, parameterStartIdx);
        }
        try {
            Method m = this.findCallableMethod(className.trim(), methodName.trim(), parameterNames.length);
            Object[] params = new Object[parameterNames.length];
            for (int i = 0; i < parameterNames.length; ++i) {
                String name = parameterNames[i];
                params[i] = parameters.get(name);
            }
            if (Modifier.isStatic(m.getModifiers())) {
                Object data = m.invoke(null, params);
                if (data == null) {
                    throw new ReportDataFactoryException("The call did not return a valid tablemodel.");
                }
                return (TableModel)data;
            }
            ClassLoader classLoader = this.getClassLoader();
            Class<?> c = Class.forName(className, false, classLoader);
            Object o = c.newInstance();
            if (o == null) {
                throw new ReportDataFactoryException("Unable to instantiate class for non static call.");
            }
            Object data = m.invoke(o, params);
            if (data == null) {
                throw new ReportDataFactoryException("The call did not return a valid tablemodel.");
            }
            return (TableModel)data;
        }
        catch (ReportDataFactoryException rdfe) {
            throw rdfe;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Something went terribly wrong: ", (Throwable)e);
        }
    }

    private String[] createParameterList(String query, int parameterStartIdx) throws ReportDataFactoryException {
        int parameterEndIdx = query.lastIndexOf(41);
        if (parameterEndIdx < parameterStartIdx) {
            throw new ReportDataFactoryException("Malformed query: " + query);
        }
        String parameterText = query.substring(parameterStartIdx + 1, parameterEndIdx);
        CSVTokenizer tokenizer = new CSVTokenizer(parameterText, ",", "\"", false);
        int size = tokenizer.countTokens();
        String[] parameterNames = new String[size];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            parameterNames[i] = tokenizer.nextToken();
            ++i;
        }
        return parameterNames;
    }

    protected ClassLoader getClassLoader() {
        return ObjectUtilities.getClassLoader(StaticDataFactory.class);
    }

    private Method findCallableMethod(String className, String methodName, int paramCount) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> c = Class.forName(className, false, classLoader);
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new ReportDataFactoryException("Abstract class cannot be handled!");
            }
            Method[] methods = c.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?> returnType;
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || !method.getName().equals(methodName) || !TableModel.class.isAssignableFrom(returnType = method.getReturnType()) || method.getParameterTypes().length != paramCount) continue;
                return method;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReportDataFactoryException("No such Class: " + className, (Throwable)e);
        }
        throw new ReportDataFactoryException("No such Method: " + className + '#' + methodName);
    }

    private Constructor findDirectConstructor(String className, int paramCount) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> c = Class.forName(className, false, classLoader);
            if (!TableModel.class.isAssignableFrom(c)) {
                throw new ReportDataFactoryException("The specified class must be either a TableModel or a ReportData implementation: " + className);
            }
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new ReportDataFactoryException("The specified class cannot be instantiated: it is abstract:" + className);
            }
            Constructor<?>[] methods = c.getConstructors();
            for (int i = 0; i < methods.length; ++i) {
                Constructor<?> method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != paramCount) continue;
                return method;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReportDataFactoryException("No such Class", (Throwable)e);
        }
        throw new ReportDataFactoryException("There is no constructor in class " + className + " that accepts " + paramCount + " parameters.");
    }

    private Constructor findIndirectConstructor(String className, int paramCount) throws ReportDataFactoryException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new ReportDataFactoryException("No classloader!");
        }
        try {
            Class<?> c = Class.forName(className, false, classLoader);
            if (Modifier.isAbstract(c.getModifiers())) {
                throw new ReportDataFactoryException("The specified class cannot be instantiated: it is abstract.");
            }
            Constructor<?>[] methods = c.getConstructors();
            for (int i = 0; i < methods.length; ++i) {
                Constructor<?> method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != paramCount) continue;
                return method;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ReportDataFactoryException("No such Class", (Throwable)e);
        }
        throw new ReportDataFactoryException("There is no constructor in class " + className + " that accepts " + paramCount + " parameters.");
    }

    public DataFactory derive() {
        return this;
    }

    public void open() throws ReportDataFactoryException {
    }

    public void close() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String[] getQueryNames() {
        return EMPTY_NAMES;
    }

    public void cancelRunningQuery() {
    }

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
    }

    public String translateQuery(String queryName) {
        return queryName;
    }
}

