/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DefaultParametrizationProviderFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProviderFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.StaticConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.ResultSetTableModelFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSQLReportDataFactory
implements DataFactory,
Cloneable {
    private transient Connection connection;
    private ConnectionProvider connectionProvider;
    private static final Log logger = LogFactory.getLog(SimpleSQLReportDataFactory.class);
    private boolean labelMapping;
    private static final String COLUMN_NAME_MAPPING_KEY = "org.pentaho.reporting.engine.classic.core.modules.data.sql.ColumnNameMapping";
    private static final String[] EMPTY_NAMES = new String[0];
    private Boolean autoCloseBehavior;
    private transient Statement currentRunningStatement;
    private Configuration configuration;
    private String userField;
    private String passwordField;
    private ResourceManager resourceManager;
    private ResourceKey contextKey;
    private ResourceBundleFactory resourceBundleFactory;

    public SimpleSQLReportDataFactory(Connection connection) {
        this(new StaticConnectionProvider(connection));
    }

    public SimpleSQLReportDataFactory(ConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.connectionProvider = connectionProvider;
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.labelMapping = "Label".equals(globalConfig.getConfigProperty(COLUMN_NAME_MAPPING_KEY, "Label"));
        this.configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
    }

    @Override
    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) throws ReportDataFactoryException {
        this.configuration = configuration == null ? ClassicEngineBoot.getInstance().getGlobalConfig() : configuration;
        this.resourceManager = resourceManager;
        this.contextKey = contextKey;
        this.resourceBundleFactory = resourceBundleFactory;
    }

    public boolean isLabelMapping() {
        return this.labelMapping;
    }

    public void setLabelMapping(boolean labelMapping) {
        this.labelMapping = labelMapping;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    protected synchronized Connection getConnection(DataRow dataRow) throws SQLException {
        if (this.connection == null) {
            Object passwordField;
            Object userRaw;
            String user = this.userField == null ? null : ((userRaw = dataRow.get(this.userField)) instanceof String ? String.valueOf(userRaw) : null);
            String password = this.passwordField == null ? null : ((passwordField = dataRow.get(this.passwordField)) instanceof String ? String.valueOf(passwordField) : null);
            this.connection = this.connectionProvider.createConnection(user, password);
        }
        if (this.connection == null) {
            throw new SQLException("Unable to get a connection from the Connection-Provider.");
        }
        if (this.autoCloseBehavior == null) {
            this.autoCloseBehavior = this.checkAutoClose(this.connection) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.connection;
    }

    private int getBestResultSetType(DataRow dataRow) throws SQLException {
        if ("simple".equalsIgnoreCase(this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TableFactoryMode"))) {
            return 1003;
        }
        Connection connection = this.getConnection(dataRow);
        boolean supportsScrollInsensitive = connection.getMetaData().supportsResultSetType(1004);
        boolean supportsScrollSensitive = connection.getMetaData().supportsResultSetType(1005);
        if (supportsScrollInsensitive) {
            return 1004;
        }
        if (supportsScrollSensitive) {
            return 1005;
        }
        return 1003;
    }

    @Override
    public synchronized TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        try {
            ParametrizationProviderFactory factory = this.createParametrizationProviderFactory();
            Connection connection = this.getConnection(parameters);
            ParametrizationProvider parametrizationProvider = factory.create(connection);
            String translatedQuery = parametrizationProvider.rewriteQueryForParametrization(connection, query, parameters);
            String[] preparedParameterNames = parametrizationProvider.getPreparedParameterNames();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Translated-Query: " + translatedQuery));
                logger.debug((Object)("Detected parameter:" + Arrays.asList(preparedParameterNames)));
            }
            TableModel tableModel = this.parametrizeAndQuery(parameters, translatedQuery, preparedParameterNames);
            return tableModel;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Failed at query: " + query, (Throwable)e);
        }
        finally {
            this.currentRunningStatement = null;
        }
    }

    private ParametrizationProviderFactory createParametrizationProviderFactory() throws ReportDataFactoryException {
        ParametrizationProviderFactory factory;
        String parametrizationProviderClassname = this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProviderFactory");
        if (parametrizationProviderClassname == null) {
            factory = new DefaultParametrizationProviderFactory();
        } else {
            factory = (ParametrizationProviderFactory)ObjectUtilities.loadAndInstantiate((String)parametrizationProviderClassname, SimpleSQLReportDataFactory.class, ParametrizationProviderFactory.class);
            if (factory == null) {
                throw new ReportDataFactoryException("The specified parametrization factory is not valid: " + parametrizationProviderClassname);
            }
        }
        return factory;
    }

    public String[] getReferencedFields(String query, DataRow parameters) throws ReportDataFactoryException {
        try {
            ParametrizationProviderFactory factory = this.createParametrizationProviderFactory();
            Connection connection = this.getConnection(parameters);
            ParametrizationProvider parametrizationProvider = factory.create(connection);
            String computedQuery = this.computedQuery(query, parameters);
            parametrizationProvider.rewriteQueryForParametrization(connection, computedQuery, parameters);
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            list.addAll(Arrays.asList(parametrizationProvider.getPreparedParameterNames()));
            if (this.userField != null) {
                list.add(this.userField);
            }
            if (this.passwordField != null) {
                list.add(this.passwordField);
            }
            list.add("::org.pentaho.reporting::query-limit");
            return list.toArray(new String[list.size()]);
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)"Unable to perform cache preparation", (Throwable)((Object)e));
            throw e;
        }
        catch (SQLException e) {
            logger.warn((Object)"Unable to perform cache preparation", (Throwable)e);
            throw new ReportDataFactoryException("Unable to perform cache preparation", (Throwable)e);
        }
    }

    protected String translateQuery(String query) {
        return query;
    }

    protected String computedQuery(String queryName, DataRow parameters) throws ReportDataFactoryException {
        return queryName;
    }

    public static boolean isExpandArrayParameterNeeded(String query) {
        return !SimpleSQLReportDataFactory.isCallableStatement(query) && !SimpleSQLReportDataFactory.isCallableStatementQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableModel parametrizeAndQuery(DataRow parameters, String translatedQuery, String[] preparedParameterNames) throws SQLException {
        ResultSet res;
        PreparedStatement pstmt;
        Statement statement;
        boolean callableStatementUsed;
        boolean callableStatementQuery = SimpleSQLReportDataFactory.isCallableStatementQuery(translatedQuery);
        boolean bl = callableStatementUsed = callableStatementQuery || SimpleSQLReportDataFactory.isCallableStatement(translatedQuery);
        if (preparedParameterNames.length == 0) {
            statement = this.getConnection(parameters).createStatement(this.getBestResultSetType(parameters), 1007);
        } else if (callableStatementUsed) {
            pstmt = this.getConnection(parameters).prepareCall(translatedQuery, this.getBestResultSetType(parameters), 1007);
            if (SimpleSQLReportDataFactory.isCallableStatementQuery(translatedQuery)) {
                pstmt.registerOutParameter(1, 1111);
                this.parametrize(parameters, preparedParameterNames, pstmt, false, 1);
            } else {
                this.parametrize(parameters, preparedParameterNames, pstmt, false, 0);
            }
            statement = pstmt;
        } else {
            pstmt = this.getConnection(parameters).prepareStatement(translatedQuery, this.getBestResultSetType(parameters), 1007);
            this.parametrize(parameters, preparedParameterNames, pstmt, this.isExpandArrays(), 0);
            statement = pstmt;
        }
        Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
        try {
            Number i;
            int max;
            if (queryLimit instanceof Number && (max = (i = (Number)queryLimit).intValue()) > 0) {
                statement.setMaxRows(max);
            }
        }
        catch (SQLException sqle) {
            logger.warn((Object)("Driver indicated error: Failed to set query-limit: " + queryLimit), (Throwable)sqle);
        }
        Object queryTimeout = parameters.get("::org.pentaho.reporting::query-timeout");
        try {
            Number i;
            int seconds;
            if (queryTimeout instanceof Number && (seconds = (i = (Number)queryTimeout).intValue()) > 0) {
                statement.setQueryTimeout(seconds);
            }
        }
        catch (SQLException sqle) {
            logger.warn((Object)("Driver indicated error: Failed to set query-timeout: " + queryTimeout), (Throwable)sqle);
        }
        try {
            this.currentRunningStatement = statement;
            if (preparedParameterNames.length == 0) {
                res = statement.executeQuery(translatedQuery);
            } else {
                PreparedStatement pstmt2 = (PreparedStatement)statement;
                res = pstmt2.executeQuery();
            }
        }
        finally {
            this.currentRunningStatement = null;
        }
        boolean simpleMode = "simple".equalsIgnoreCase(this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TableFactoryMode"));
        if (simpleMode || this.autoCloseBehavior == Boolean.TRUE) {
            return ResultSetTableModelFactory.getInstance().generateDefaultTableModel(res, this.labelMapping);
        }
        return ResultSetTableModelFactory.getInstance().createTableModel(res, this.labelMapping, true);
    }

    private void parametrize(DataRow parameters, String[] params, PreparedStatement pstmt, boolean expandArrays, int parameterOffset) throws SQLException {
        pstmt.clearParameters();
        int paramIndex = parameterOffset;
        for (int i = 0; i < params.length; ++i) {
            String param = params[i];
            Object pvalue = parameters.get(param);
            if (pvalue == null) {
                pstmt.setObject(paramIndex + 1, null);
                logger.debug((Object)("Parametrize: " + (paramIndex + 1) + " set to <null>"));
                ++paramIndex;
                continue;
            }
            if (expandArrays && pvalue instanceof Object[]) {
                Object[] values = (Object[])pvalue;
                if (values.length > 0) {
                    for (int j = 0; j < values.length; ++j) {
                        Object ivalue = values[j];
                        if (ivalue instanceof Date || ivalue instanceof Time || ivalue instanceof Timestamp) {
                            pstmt.setObject(paramIndex + 1, ivalue);
                        } else if (ivalue instanceof java.util.Date) {
                            java.util.Date d = (java.util.Date)ivalue;
                            pstmt.setObject(paramIndex + 1, new Timestamp(d.getTime()));
                        } else {
                            pstmt.setObject(paramIndex + 1, ivalue);
                        }
                        logger.debug((Object)("Parametrize: Array: " + (paramIndex + 1) + ": " + ivalue));
                        ++paramIndex;
                    }
                    continue;
                }
                pstmt.setObject(paramIndex + 1, null);
                logger.debug((Object)("Parametrize: Array: " + (paramIndex + 1) + " set to <null> for empty array"));
                ++paramIndex;
                continue;
            }
            if (pvalue instanceof Date || pvalue instanceof Time || pvalue instanceof Timestamp) {
                pstmt.setObject(paramIndex + 1, pvalue);
            } else if (pvalue instanceof java.util.Date) {
                java.util.Date d = (java.util.Date)pvalue;
                pstmt.setObject(paramIndex + 1, new Timestamp(d.getTime()));
            } else {
                pstmt.setObject(paramIndex + 1, pvalue);
            }
            logger.debug((Object)("Parametrize: " + (paramIndex + 1) + ": " + pvalue));
            ++paramIndex;
        }
    }

    protected boolean isExpandArrays() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRunningQuery() {
        if (this.currentRunningStatement == null) {
            return;
        }
        try {
            logger.debug((Object)"Cancelling the running query...");
            this.currentRunningStatement.cancel();
        }
        catch (SQLException e) {
            logger.warn((Object)("Could not cancel running query [maybe the driver does not support that operation] : " + e.getMessage()));
        }
        finally {
            logger.debug((Object)"Returning from attempt to cancel current running statement");
        }
    }

    private static boolean isCallableStatement(String query) {
        int state = 0;
        char[] chars = query.toCharArray();
        int length = query.length();
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (state != 5) continue;
                return true;
            }
            if ('{' == c && state == 0) {
                state = 1;
                continue;
            }
            if (('c' == c || 'C' == c) && state == 1) {
                state = 2;
                continue;
            }
            if (('a' == c || 'A' == c) && state == 2) {
                state = 3;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 4) {
                state = 4;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 5) {
                state = 5;
                continue;
            }
            return state == 5;
        }
        return false;
    }

    private static boolean isCallableStatementQuery(String query) {
        int state = 0;
        char[] chars = query.toCharArray();
        int length = query.length();
        for (int i = 0; i < length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                if (state != 7) continue;
                return true;
            }
            if ('{' == c && state == 0) {
                state = 1;
                continue;
            }
            if ('?' == c && state == 1) {
                state = 2;
                continue;
            }
            if ('=' == c && state == 2) {
                state = 3;
                continue;
            }
            if (('c' == c || 'C' == c) && state == 3) {
                state = 4;
                continue;
            }
            if (('a' == c || 'A' == c) && state == 4) {
                state = 5;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 5) {
                state = 6;
                continue;
            }
            if (('l' == c || 'L' == c) && state == 6) {
                state = 7;
                continue;
            }
            return state == 7;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAutoClose(Connection connection) {
        try {
            String statementTest = this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.CheckAutoCloseQuery", "SELECT 1");
            PreparedStatement statement = connection.prepareStatement(statementTest);
            try {
                ResultSet resultSet1 = statement.executeQuery();
                try {
                    ResultSet resultSet2 = statement.executeQuery();
                    try {
                        resultSet2.next();
                    }
                    finally {
                        resultSet2.close();
                    }
                    resultSet1.next();
                }
                finally {
                    resultSet1.close();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            return false;
        }
        catch (SQLException e) {
            return true;
        }
    }

    @Override
    public void open() throws ReportDataFactoryException {
    }

    @Override
    public synchronized void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.autoCloseBehavior = null;
        this.connection = null;
    }

    @Override
    public DataFactory derive() {
        return (DataFactory)this.clone();
    }

    @Override
    public Object clone() {
        try {
            SimpleSQLReportDataFactory dataFactory = (SimpleSQLReportDataFactory)super.clone();
            dataFactory.connection = null;
            return dataFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        this.connectionProvider = connectionProvider;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        return true;
    }

    @Override
    public String[] getQueryNames() {
        return EMPTY_NAMES;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected ResourceKey getContextKey() {
        return this.contextKey;
    }

    protected ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public ArrayList<Object> getQueryHash(String queryName, DataRow parameter) {
        Object connection = this.getConnectionProvider().getConnectionHash();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getClass().getName());
        list.add(this.translateQuery(queryName));
        list.add(connection);
        return list;
    }
}

