/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.referencedoc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;

public class ObjectReferenceTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"object-factory", "object-class", "parameter-name", "parameter-class"};
    private final ArrayList rows = new ArrayList();

    public ObjectReferenceTableModel(ClassFactoryCollector cf) {
        this.addClassFactoryCollector(cf);
    }

    private void addClassFactoryCollector(ClassFactoryCollector cf) {
        Iterator it = cf.getFactories();
        while (it.hasNext()) {
            ClassFactory cfact = (ClassFactory)it.next();
            if (cfact instanceof ClassFactoryCollector) {
                this.addClassFactoryCollector((ClassFactoryCollector)cfact);
                continue;
            }
            this.addClassFactory(cfact);
        }
    }

    private void addClassFactory(ClassFactory cf) {
        Iterator it = cf.getRegisteredClasses();
        ArrayList<Class> factories = new ArrayList<Class>();
        while (it.hasNext()) {
            Class c = (Class)it.next();
            factories.add(c);
        }
        Collections.sort(factories, new ClassNameComparator());
        for (Class c : factories) {
            ObjectDescription od = cf.getDescriptionForClass(c);
            Iterator itNames = od.getParameterNames();
            ArrayList nameList = new ArrayList();
            while (itNames.hasNext()) {
                nameList.add(itNames.next());
            }
            Collections.sort(nameList);
            for (String name : nameList) {
                this.rows.add(new ObjectDescriptionRow(cf, c, name, od.getParameterDefinition(name)));
            }
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ObjectDescriptionRow or = (ObjectDescriptionRow)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(or.getClassFactory().getClass().getName());
            }
            case 1: {
                return String.valueOf(or.getObject().getName());
            }
            case 2: {
                return String.valueOf(or.getParamName());
            }
            case 3: {
                return String.valueOf(or.getParamType().getName());
            }
        }
        return null;
    }

    private static class ClassNameComparator
    implements Comparator,
    Serializable {
        private ClassNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }

    private static class ObjectDescriptionRow {
        private final ClassFactory classFactory;
        private final Class object;
        private final String paramName;
        private final Class paramType;

        private ObjectDescriptionRow(ClassFactory classFactory, Class object, String paramName, Class paramType) {
            this.classFactory = classFactory;
            this.object = object;
            this.paramName = paramName;
            this.paramType = paramType;
        }

        public ClassFactory getClassFactory() {
            return this.classFactory;
        }

        public Class getObject() {
            return this.object;
        }

        public String getParamName() {
            return this.paramName;
        }

        public Class getParamType() {
            return this.paramType;
        }
    }
}

