/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.referencedoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactoryCollector;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class StyleKeyReferenceTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"stylekey-factory", "key-name", "key-class", "inherit", "transient"};
    private final ArrayList rows = new ArrayList();

    public StyleKeyReferenceTableModel(StyleKeyFactoryCollector cf) {
        this.addStyleKeyFactoryCollector(cf);
    }

    private void addStyleKeyFactoryCollector(StyleKeyFactoryCollector cf) {
        Iterator it = cf.getFactories();
        while (it.hasNext()) {
            StyleKeyFactory cfact = (StyleKeyFactory)it.next();
            if (cfact instanceof StyleKeyFactoryCollector) {
                this.addStyleKeyFactoryCollector((StyleKeyFactoryCollector)cfact);
                continue;
            }
            this.addStyleKeyFactory(cfact);
        }
    }

    private void addStyleKeyFactory(StyleKeyFactory cf) {
        Iterator it = cf.getRegisteredKeys();
        ArrayList<String> factories = new ArrayList<String>();
        while (it.hasNext()) {
            String c = (String)it.next();
            factories.add(c);
        }
        Collections.sort(factories);
        for (String keyName : factories) {
            StyleKey key = cf.getStyleKey(keyName);
            this.rows.add(new StylekeyDescriptionRow(cf, key));
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 3) {
            return String.class;
        }
        return Boolean.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        StylekeyDescriptionRow or = (StylekeyDescriptionRow)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return String.valueOf(or.getKeyFactory().getClass().getName());
            }
            case 1: {
                return String.valueOf(or.getKey().getName());
            }
            case 2: {
                return String.valueOf(or.getKey().getValueType().getName());
            }
            case 3: {
                return or.getKey().isInheritable() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return or.getKey().isTransient() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    private static class StylekeyDescriptionRow {
        private final StyleKeyFactory keyFactory;
        private final StyleKey key;

        private StylekeyDescriptionRow(StyleKeyFactory keyFactory, StyleKey key) {
            this.keyFactory = keyFactory;
            this.key = key;
        }

        public StyleKeyFactory getKeyFactory() {
            return this.keyFactory;
        }

        public StyleKey getKey() {
            return this.key;
        }
    }
}

