/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.survey;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScale;

public class SurveyScaleExpression
extends AbstractExpression {
    private int lowest;
    private int highest;
    private ArrayList fieldList;
    private String rangeLowerBoundField;
    private String rangeUpperBoundField;
    private Paint rangePaint;
    private Shape overrideShape;
    private boolean overrideShapeFilled;

    public SurveyScaleExpression() {
        this(0, 1);
    }

    public SurveyScaleExpression(int lowest, int highest) {
        this(lowest, highest, null, null, null);
    }

    public SurveyScaleExpression(int lowest, int highest, String lowerBoundsField, String upperBoundsField, Shape shape) {
        this.lowest = lowest;
        this.highest = highest;
        this.fieldList = new ArrayList();
        this.overrideShape = shape;
        this.overrideShapeFilled = false;
        this.rangeLowerBoundField = lowerBoundsField;
        this.rangeUpperBoundField = upperBoundsField;
        this.rangePaint = Color.lightGray;
    }

    public String getRangeLowerBoundField() {
        return this.rangeLowerBoundField;
    }

    public void setRangeLowerBoundField(String field) {
        this.rangeLowerBoundField = field;
    }

    public String getRangeUpperBoundField() {
        return this.rangeUpperBoundField;
    }

    public void setRangeUpperBoundField(String field) {
        this.rangeUpperBoundField = field;
    }

    public Shape getOverrideShape() {
        return this.overrideShape;
    }

    public void setOverrideShape(Shape shape) {
        this.overrideShape = shape;
    }

    public void setOverrideShapeFilled(boolean b) {
        this.overrideShapeFilled = b;
    }

    public int getLowest() {
        return this.lowest;
    }

    public void setLowest(int lowest) {
        this.lowest = lowest;
    }

    public int getHighest() {
        return this.highest;
    }

    public void setHighest(int highest) {
        this.highest = highest;
    }

    public Object getValue() {
        SurveyScale result = new SurveyScale(this.lowest, this.highest, this.collectValues());
        if (this.rangeLowerBoundField != null && this.rangeUpperBoundField != null) {
            Number b0 = (Number)this.getDataRow().get(this.rangeLowerBoundField);
            Number b1 = (Number)this.getDataRow().get(this.rangeUpperBoundField);
            result.setRangeLowerBound(b0);
            result.setRangeUpperBound(b1);
        }
        result.setRangePaint(this.rangePaint);
        if (this.overrideShape != null) {
            result.setShape(0, this.overrideShape);
            result.setShapeFilled(0, this.overrideShapeFilled);
        }
        return result;
    }

    private Number[] collectValues() {
        Number[] retval = new Number[this.fieldList.size()];
        for (int i = 0; i < this.fieldList.size(); ++i) {
            String field = (String)this.fieldList.get(i);
            retval[i] = (Number)this.getDataRow().get(field);
        }
        return retval;
    }

    public Object clone() throws CloneNotSupportedException {
        SurveyScaleExpression fva = (SurveyScaleExpression)super.clone();
        fva.fieldList = (ArrayList)this.fieldList.clone();
        return fva;
    }

    public String[] getField() {
        return this.fieldList.toArray(new String[this.fieldList.size()]);
    }

    public void setField(String[] fields) {
        this.fieldList.clear();
        this.fieldList.addAll(Arrays.asList(fields));
    }

    public String getField(int idx) {
        return (String)this.fieldList.get(idx);
    }

    public void setField(int index, String field) {
        if (this.fieldList.size() == index) {
            this.fieldList.add(field);
        } else {
            this.fieldList.set(index, field);
        }
    }

    public boolean isOverrideShapeFilled() {
        return this.overrideShapeFilled;
    }

    public Paint getRangePaint() {
        return this.rangePaint;
    }

    public void setRangePaint(Paint rangePaint) {
        if (rangePaint == null) {
            throw new NullPointerException();
        }
        this.rangePaint = rangePaint;
    }
}

