/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel;

import javax.swing.table.AbstractTableModel;

public class CSVTableModel
extends AbstractTableModel {
    private static final Object[][] EMPTY_DATA = new Object[0][0];
    private static final String[] EMPTY_NAMES = new String[0];
    private String[] columnNames = EMPTY_NAMES;
    private int maxColumnCount;
    private Object[][] data = EMPTY_DATA;

    public Object[][] getData() {
        return (Object[][])this.data.clone();
    }

    public void setData(Object[][] data) {
        this.data = (Object[][])data.clone();
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = (String[])columnNames.clone();
    }

    public int getColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        return this.maxColumnCount;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] line = this.data[rowIndex];
        if (line.length < columnIndex) {
            return null;
        }
        return line[columnIndex];
    }

    public void setMaxColumnCount(int maxColumnCount) {
        if (this.maxColumnCount < maxColumnCount) {
            this.maxColumnCount = maxColumnCount;
        }
    }

    public int getMaxColumnCount() {
        return this.maxColumnCount;
    }

    public String getColumnName(int column) {
        if (this.columnNames != null) {
            return this.columnNames[column];
        }
        if (column >= this.maxColumnCount) {
            throw new IllegalArgumentException("Column (" + column + ") does not exist");
        }
        return "COLUMN_" + column;
    }
}

