/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.DataTableException;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.DefaultTableMetaData;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.ResultSetTableModelFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel.TypeMapper;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;

public class ScrollableResultSetTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private ResultSet resultset;
    private ResultSetMetaData dbmd;
    private int rowCount;
    private final boolean labelMapMode;
    private boolean closeStatement;
    private Class[] types;
    private DefaultTableMetaData metaData;

    public ScrollableResultSetTableModel(ResultSet resultset, boolean labelMapMode) throws SQLException {
        this(resultset, labelMapMode, false);
    }

    public ScrollableResultSetTableModel(ResultSet resultset, boolean labelMapMode, boolean closeStatement) throws SQLException {
        this.labelMapMode = labelMapMode;
        this.closeStatement = closeStatement;
        if (resultset != null) {
            this.updateResultSet(resultset);
        } else {
            this.close();
        }
    }

    protected ScrollableResultSetTableModel(boolean labelMapMode) {
        this.labelMapMode = labelMapMode;
    }

    public boolean isLabelMapMode() {
        return this.labelMapMode;
    }

    public void updateResultSet(ResultSet resultset) throws SQLException {
        if (this.resultset != null) {
            this.close();
        }
        this.resultset = resultset;
        this.dbmd = resultset.getMetaData();
        int colcount = this.dbmd.getColumnCount();
        this.metaData = new DefaultTableMetaData(colcount);
        for (int i = 0; i < colcount; ++i) {
            ResultSetTableModelFactory.updateMetaData(this.dbmd, this.metaData, i);
        }
        this.rowCount = resultset.last() ? resultset.getRow() : 0;
        this.fireTableStructureChanged();
    }

    public void close() {
        if (this.resultset != null) {
            Statement statement = null;
            try {
                statement = this.resultset.getStatement();
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                this.resultset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            if (this.closeStatement) {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this.resultset = null;
        this.dbmd = null;
        this.rowCount = 0;
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        if (this.resultset == null) {
            return 0;
        }
        try {
            if (this.resultset.last()) {
                this.rowCount = this.resultset.getRow();
                if (this.rowCount == -1) {
                    this.rowCount = 0;
                }
            } else {
                this.rowCount = 0;
            }
        }
        catch (SQLException sqle) {
            throw new DataTableException("Accessing the result set failed: ", sqle);
        }
        return this.rowCount;
    }

    public int getColumnCount() {
        if (this.resultset == null) {
            return 0;
        }
        if (this.dbmd != null) {
            try {
                return this.dbmd.getColumnCount();
            }
            catch (SQLException e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return 0;
    }

    public String getColumnName(int column) {
        if (this.dbmd != null) {
            try {
                if (this.isLabelMapMode()) {
                    return this.dbmd.getColumnLabel(column + 1);
                }
                return this.dbmd.getColumnName(column + 1);
            }
            catch (SQLException e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return null;
    }

    public Object getValueAt(int row, int column) {
        if (this.resultset != null) {
            try {
                this.resultset.absolute(row + 1);
                return this.resultset.getObject(column + 1);
            }
            catch (SQLException e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        if (this.types != null) {
            return this.types[column];
        }
        if (this.dbmd != null) {
            try {
                this.types = TypeMapper.mapTypes(this.dbmd);
                if (this.types != null) {
                    return this.types[column];
                }
            }
            catch (Exception e) {
                throw new DataTableException("Accessing the result set failed: ", e);
            }
        }
        return Object.class;
    }

    public String getColumnClassName(int column) {
        if (this.dbmd != null) {
            return this.mckoiDBFixClassName(this.getColumnClass(column).getName());
        }
        return Object.class.getName();
    }

    private String mckoiDBFixClassName(String classname) {
        if (classname.startsWith("class ")) {
            return classname.substring(6).trim();
        }
        return classname;
    }

    public DataAttributes getCellDataAttributes(int row, int column) {
        if (this.metaData == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        return this.metaData.getCellDataAttribute(row, column);
    }

    public boolean isCellDataAttributesSupported() {
        return this.metaData.isCellDataAttributesSupported();
    }

    public DataAttributes getColumnAttributes(int column) {
        if (this.metaData == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        return this.metaData.getColumnAttribute(column);
    }

    public DataAttributes getTableAttributes() {
        if (this.metaData == null) {
            return null;
        }
        return this.metaData.getTableAttribute();
    }
}

