/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel;

import java.io.PrintStream;
import java.util.Locale;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;

public final class TableModelInfo {
    private TableModelInfo() {
    }

    public static void printTableMetaData(TableModel mod, PrintStream out) {
        if (!(mod instanceof MetaTableModel)) {
            out.println("TableModel has no meta-data.");
            return;
        }
        MetaTableModel metaTableModel = (MetaTableModel)mod;
        DataAttributes tableAttributes = metaTableModel.getTableAttributes();
        DefaultDataAttributeContext attributeContext = new DefaultDataAttributeContext(new GenericOutputProcessorMetaData(), Locale.US);
        String[] tableAttrDomains = tableAttributes.getMetaAttributeDomains();
        for (int i = 0; i < tableAttrDomains.length; ++i) {
            String tableAttrDomain = tableAttrDomains[i];
            String[] attributeNames = tableAttributes.getMetaAttributeNames(tableAttrDomain);
            for (int j = 0; j < attributeNames.length; ++j) {
                String attributeName = attributeNames[j];
                Object o = tableAttributes.getMetaAttribute(tableAttrDomain, attributeName, Object.class, attributeContext);
                out.println("TableAttribute [" + tableAttrDomain + ':' + attributeName + "]=" + o);
            }
        }
        for (int column = 0; column < mod.getColumnCount(); ++column) {
            DataAttributes columnAttributes = metaTableModel.getColumnAttributes(column);
            String[] columnAttributeDomains = columnAttributes.getMetaAttributeDomains();
            for (int i = 0; i < columnAttributeDomains.length; ++i) {
                String colAttrDomain = columnAttributeDomains[i];
                String[] attributeNames = columnAttributes.getMetaAttributeNames(colAttrDomain);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String attributeName = attributeNames[j];
                    Object o = columnAttributes.getMetaAttribute(colAttrDomain, attributeName, Object.class, attributeContext);
                    out.println("ColumnAttribute(" + column + ") [" + colAttrDomain + ':' + attributeName + "]=" + o);
                }
            }
        }
    }

    public static void printTableCellAttributes(TableModel mod, PrintStream out) {
        if (!(mod instanceof MetaTableModel)) {
            out.println("TableModel has no meta-data.");
            return;
        }
        MetaTableModel metaTableModel = (MetaTableModel)mod;
        if (!metaTableModel.isCellDataAttributesSupported()) {
            out.println("TableModel has no cell-meta-data.");
            return;
        }
        DefaultDataAttributeContext attributeContext = new DefaultDataAttributeContext(new GenericOutputProcessorMetaData(), Locale.US);
        out.println("Tablemodel contains " + mod.getRowCount() + " rows.");
        out.println("Checking the attributes inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                DataAttributes cellAttributes = metaTableModel.getCellDataAttributes(rows, i);
                String[] columnAttributeDomains = cellAttributes.getMetaAttributeDomains();
                for (int attrDomainIdx = 0; attrDomainIdx < columnAttributeDomains.length; ++attrDomainIdx) {
                    String colAttrDomain = columnAttributeDomains[attrDomainIdx];
                    String[] attributeNames = cellAttributes.getMetaAttributeNames(colAttrDomain);
                    for (int j = 0; j < attributeNames.length; ++j) {
                        String attributeName = attributeNames[j];
                        Object o = cellAttributes.getMetaAttribute(colAttrDomain, attributeName, Object.class, attributeContext);
                        out.println("CellAttribute(" + rows + ", " + i + ") [" + colAttrDomain + ':' + attributeName + "]=" + o);
                    }
                }
            }
        }
    }

    public static void printTableModel(TableModel mod, PrintStream out) {
        out.println("Tablemodel contains " + mod.getRowCount() + " rows.");
        for (int i = 0; i < mod.getColumnCount(); ++i) {
            out.println("Column: " + i + " Name=" + mod.getColumnName(i) + "; DataType=" + mod.getColumnClass(i));
        }
        out.println("Checking the data inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                Object value = mod.getValueAt(rows, i);
                Class<?> c = mod.getColumnClass(i);
                if (value == null) {
                    out.println("ValueAt (" + rows + ", " + i + ") is null");
                    continue;
                }
                if (!c.isAssignableFrom(value.getClass())) {
                    out.println("ValueAt (" + rows + ", " + i + ") is not assignable from " + c);
                    continue;
                }
                if (c.equals(Object.class)) {
                    out.println("ValueAt (" + rows + ", " + i + ") is in a generic column and is of " + "type " + value.getClass());
                    continue;
                }
                out.println("ValueAt (" + rows + ", " + i + ") is in a typed column and is of " + "type " + value.getClass());
            }
        }
    }

    public static void printTableModel(TableModel mod) {
        TableModelInfo.printTableModel(mod, System.out);
    }

    public static void printTableModelContents(TableModel mod, PrintStream out) {
        out.println("Tablemodel contains " + mod.getRowCount() + " rows.");
        for (int i = 0; i < mod.getColumnCount(); ++i) {
            out.println("Column: " + i + " Name=" + mod.getColumnName(i) + "; DataType=" + mod.getColumnClass(i));
        }
        out.println("Checking the data inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                Object value = mod.getValueAt(rows, i);
                out.println("ValueAt (" + rows + ", " + i + ") is '" + value + "'");
            }
        }
    }

    public static void printTableModelContents(TableModel mod) {
        TableModelInfo.printTableModelContents(mod, System.out);
    }
}

