/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.csv;

public class CSVQuoter {
    private String separator;

    public CSVQuoter() {
        this(",");
    }

    public CSVQuoter(String separator) {
        this.setSeparator(separator);
    }

    public String doQuoting(String original) {
        if (this.isQuotingNeeded(original)) {
            StringBuffer retval = new StringBuffer(original.length() + 10);
            retval.append('\"');
            this.applyQuote(retval, original);
            retval.append('\"');
            return retval.toString();
        }
        return original;
    }

    public String undoQuoting(String nativeString) {
        if (this.isQuotingNeeded(nativeString)) {
            int start;
            StringBuilder b = new StringBuilder(nativeString.length());
            int length = nativeString.length() - 1;
            int pos = start = 1;
            while (pos != -1) {
                pos = nativeString.indexOf("\"\"", start);
                if (pos == -1) {
                    b.append(nativeString.substring(start, length));
                    continue;
                }
                b.append(nativeString.substring(start, pos));
                start = pos + 1;
            }
            return b.toString();
        }
        return nativeString;
    }

    private boolean isQuotingNeeded(String str) {
        if (str.indexOf(this.separator) != -1) {
            return true;
        }
        if (str.indexOf(10) != -1) {
            return true;
        }
        return str.indexOf(34, 1) != -1;
    }

    private void applyQuote(StringBuffer b, String original) {
        int length = original.length();
        for (int i = 0; i < length; ++i) {
            char c = original.charAt(i);
            if (c == '\"') {
                b.append("\"\"");
                continue;
            }
            b.append(c);
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        if (separator == null) {
            throw new NullPointerException();
        }
        this.separator = separator;
    }
}

