/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionProcessingException;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.csv.CSVQuoter;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;

public class CSVWriter
extends AbstractFunction
implements OutputFunction {
    private Writer w;
    private int depLevel;
    private final CSVQuoter quoter;
    private boolean writeDataRowNames;
    private boolean writeStateColumns;
    private boolean enableReportHeader;
    private boolean enableReportFooter;
    private boolean enableGroupHeader;
    private boolean enableGroupFooter;
    private boolean enableItemband;
    private ArrayList inlineSubreports;

    public CSVWriter() {
        this.setDependencyLevel(-2);
        this.quoter = new CSVQuoter();
        this.inlineSubreports = new ArrayList();
    }

    public boolean isWriteDataRowNames() {
        return this.writeDataRowNames;
    }

    public void setWriteDataRowNames(boolean writeDataRowNames) {
        this.writeDataRowNames = writeDataRowNames;
    }

    public boolean isWriteStateColumns() {
        return this.writeStateColumns;
    }

    public void setWriteStateColumns(boolean writeStateColumns) {
        this.writeStateColumns = writeStateColumns;
    }

    public boolean isEnableGroupFooter() {
        return this.enableGroupFooter;
    }

    public void setEnableGroupFooter(boolean enableGroupFooter) {
        this.enableGroupFooter = enableGroupFooter;
    }

    public boolean isEnableGroupHeader() {
        return this.enableGroupHeader;
    }

    public void setEnableGroupHeader(boolean enableGroupHeader) {
        this.enableGroupHeader = enableGroupHeader;
    }

    public boolean isEnableItemband() {
        return this.enableItemband;
    }

    public void setEnableItemband(boolean enableItemband) {
        this.enableItemband = enableItemband;
    }

    public boolean isEnableReportFooter() {
        return this.enableReportFooter;
    }

    public void setEnableReportFooter(boolean enableReportFooter) {
        this.enableReportFooter = enableReportFooter;
    }

    public boolean isEnableReportHeader() {
        return this.enableReportHeader;
    }

    public void setEnableReportHeader(boolean enableReportHeader) {
        this.enableReportHeader = enableReportHeader;
    }

    public Writer getWriter() {
        return this.w;
    }

    public void setWriter(Writer w) {
        this.w = w;
    }

    public void setSeparator(String separator) {
        if (separator == null) {
            throw new NullPointerException();
        }
        if (separator.length() == 0) {
            throw new IllegalArgumentException("Separator must not be an empty string");
        }
        this.quoter.setSeparator(separator);
    }

    public String getSeparator() {
        return this.quoter.getSeparator();
    }

    private void writeDataRow(DataRow dr, CSVRow row) {
        String[] names = dr.getColumnNames();
        int length = names.length;
        for (int i = 0; i < length; ++i) {
            Object o = dr.get(names[i]);
            row.append(o);
        }
    }

    private void writeDataRowNames(DataRow dr, CSVRow row) {
        for (String columnName : dr.getColumnNames()) {
            row.append(columnName);
        }
    }

    public void reportStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            this.collectSubReports(event.getReport().getReportHeader());
            return;
        }
        try {
            if (this.isWriteDataRowNames()) {
                CSVRow names = new CSVRow(this.quoter);
                if (this.isWriteStateColumns()) {
                    names.append("report.currentgroup");
                    names.append("report.eventtype");
                }
                this.writeDataRowNames(event.getDataRow(), names);
                names.write(this.getWriter());
            }
            if (!this.isEnableReportHeader()) {
                return;
            }
            CSVRow row = new CSVRow(this.quoter);
            if (this.isWriteStateColumns()) {
                row.append(-1);
                row.append("reportheader");
            }
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
            this.collectSubReports(event.getReport().getReportHeader());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void reportFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            this.collectSubReports(event.getReport().getReportFooter());
            return;
        }
        if (!this.isEnableReportFooter()) {
            this.collectSubReports(event.getReport().getReportFooter());
            return;
        }
        try {
            CSVRow row = new CSVRow(this.quoter);
            if (this.isWriteStateColumns()) {
                row.append(-1);
                row.append("reportfooter");
            }
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
            this.collectSubReports(event.getReport().getReportFooter());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            int currentIndex = event.getState().getCurrentGroupIndex();
            Group g = event.getReport().getGroup(currentIndex);
            this.collectSubReports(g.getHeader());
            return;
        }
        if (!this.isEnableGroupHeader()) {
            int currentIndex = event.getState().getCurrentGroupIndex();
            Group g = event.getReport().getGroup(currentIndex);
            this.collectSubReports(g.getHeader());
            return;
        }
        try {
            Group g;
            int currentIndex = event.getState().getCurrentGroupIndex();
            CSVRow row = new CSVRow(this.quoter);
            if (this.isWriteStateColumns()) {
                row.append(currentIndex);
                g = event.getReport().getGroup(currentIndex);
                String bandInfo = "groupheader name=\"" + g.getName() + '\"';
                row.append(bandInfo);
            }
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
            g = event.getReport().getGroup(currentIndex);
            this.collectSubReports(g.getHeader());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void groupFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            int currentIndex = event.getState().getCurrentGroupIndex();
            Group g = event.getReport().getGroup(currentIndex);
            this.collectSubReports(g.getFooter());
            return;
        }
        if (!this.isEnableGroupFooter()) {
            int currentIndex = event.getState().getCurrentGroupIndex();
            Group g = event.getReport().getGroup(currentIndex);
            this.collectSubReports(g.getFooter());
            return;
        }
        try {
            Group g;
            int currentIndex = event.getState().getCurrentGroupIndex();
            CSVRow row = new CSVRow(this.quoter);
            if (this.isWriteStateColumns()) {
                row.append(currentIndex);
                g = event.getReport().getGroup(currentIndex);
                String bandInfo = "groupfooter name=\"" + g.getName() + '\"';
                row.append(bandInfo);
            }
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
            g = event.getReport().getGroup(currentIndex);
            this.collectSubReports(g.getFooter());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public void itemsStarted(ReportEvent event) {
        this.collectSubReports(event.getReport().getDetailsHeader());
    }

    public void itemsFinished(ReportEvent event) {
        this.collectSubReports(event.getReport().getDetailsFooter());
    }

    public void itemsAdvanced(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            this.collectSubReports(event.getReport().getItemBand());
            return;
        }
        if (!this.isEnableItemband()) {
            this.collectSubReports(event.getReport().getItemBand());
            return;
        }
        try {
            CSVRow row = new CSVRow(this.quoter);
            if (this.isWriteStateColumns()) {
                row.append(event.getState().getCurrentGroupIndex());
                row.append("itemband");
            }
            this.writeDataRow(event.getDataRow(), row);
            row.write(this.getWriter());
            this.collectSubReports(event.getReport().getItemBand());
        }
        catch (IOException ioe) {
            throw new FunctionProcessingException("Error writing the current datarow", ioe);
        }
    }

    public Object getValue() {
        return this;
    }

    public int getDependencyLevel() {
        return this.depLevel;
    }

    public void setDependencyLevel(int deplevel) {
        this.depLevel = deplevel;
    }

    public OutputFunction deriveForStorage() {
        try {
            return (OutputFunction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public OutputFunction deriveForPagebreak() {
        try {
            return (OutputFunction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CSVWriter o = (CSVWriter)super.clone();
        o.inlineSubreports = (ArrayList)this.inlineSubreports.clone();
        return o;
    }

    public InlineSubreportMarker[] getInlineSubreports() {
        return this.inlineSubreports.toArray(new InlineSubreportMarker[this.inlineSubreports.size()]);
    }

    public void clearInlineSubreports(SubReportProcessType inlineExecution) {
        InlineSubreportMarker[] subreports = this.getInlineSubreports();
        for (int i = 0; i < subreports.length; ++i) {
            InlineSubreportMarker subreport = subreports[i];
            if (inlineExecution != subreport.getProcessType()) continue;
            this.inlineSubreports.remove(i);
        }
    }

    private void collectSubReports(Band band) throws FunctionProcessingException {
        Element[] elements = band.getElementArray();
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            if (element instanceof SubReport) {
                try {
                    this.inlineSubreports.add(element.clone());
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    throw new FunctionProcessingException("Failed to clone subreport", e);
                }
            }
            if (!(element instanceof Band)) continue;
            this.collectSubReports((Band)element);
        }
    }

    public void restart(ReportState state) {
    }

    public boolean createRollbackInformation() {
        return false;
    }

    private static class CSVRow {
        private final ArrayList data = new ArrayList();
        private final CSVQuoter quoter;
        private final String lineSeparator;

        protected CSVRow(CSVQuoter quoter) {
            this.quoter = quoter;
            this.lineSeparator = ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("line.separator", "\n");
        }

        public void append(int value) {
            this.data.add(new Integer(value));
        }

        public void append(Object o) {
            this.data.add(o);
        }

        public void write(Writer w) throws IOException {
            Iterator it = this.data.iterator();
            while (it.hasNext()) {
                w.write(this.quoter.doQuoting(String.valueOf(it.next())));
                if (!it.hasNext()) continue;
                w.write(this.quoter.getSeparator());
            }
            w.write(this.lineSeparator);
        }
    }
}

