/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;

public abstract class AbstractPageableOutputProcessor
extends AbstractOutputProcessor
implements PageableOutputProcessor {
    private List physicalPages = new ArrayList();

    protected AbstractPageableOutputProcessor() {
    }

    protected void reset() {
        super.reset();
        this.physicalPages = new ArrayList();
    }

    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    public PhysicalPageKey getPhysicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return (PhysicalPageKey)this.physicalPages.get(page);
    }

    protected LogicalPageKey createLogicalPage(int width, int height) {
        LogicalPageKey key = super.createLogicalPage(width, height);
        for (int h = 0; h < key.getHeight(); ++h) {
            for (int w = 0; w < key.getWidth(); ++w) {
                this.physicalPages.add(key.getPage(w, h));
            }
        }
        return key;
    }

    protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
        PageGrid pageGrid = logicalPage.getPageGrid();
        int rowCount = pageGrid.getRowCount();
        int colCount = pageGrid.getColumnCount();
        PageFlowSelector selector = this.getFlowSelector();
        if (selector != null) {
            if (selector.isLogicalPageAccepted(logicalPageKey)) {
                this.processLogicalPage(logicalPageKey, logicalPage);
            }
            for (int row = 0; row < rowCount; ++row) {
                for (int col = 0; col < colCount; ++col) {
                    PhysicalPageKey pageKey = logicalPageKey.getPage(col, row);
                    if (!selector.isPhysicalPageAccepted(pageKey)) continue;
                    this.processPhysicalPage(pageGrid, logicalPage, row, col, pageKey);
                }
            }
        }
    }

    protected abstract PageFlowSelector getFlowSelector();

    protected abstract void processPhysicalPage(PageGrid var1, LogicalPageBox var2, int var3, int var4, PhysicalPageKey var5) throws ContentProcessingException;

    protected abstract void processLogicalPage(LogicalPageKey var1, LogicalPageBox var2) throws ContentProcessingException;
}

