/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.base;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.layout.AbstractRenderer;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyPageShiftValuesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CleanPaginatedBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.FillPhysicalPagesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationResult;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationStep;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class PageableRenderer
extends AbstractRenderer {
    private static final Log logger = LogFactory.getLog(PageableRenderer.class);
    private PaginationStep paginationStep = new PaginationStep();
    private FillPhysicalPagesStep fillPhysicalPagesStep = new FillPhysicalPagesStep();
    private CleanPaginatedBoxesStep cleanPaginatedBoxesStep = new CleanPaginatedBoxesStep();
    private ApplyPageShiftValuesStep applyPageShiftValuesStep = new ApplyPageShiftValuesStep();
    private int pageCount;
    private long lastPageAge = System.currentTimeMillis();
    private boolean pageStartPending;

    public PageableRenderer(OutputProcessor outputProcessor) {
        super(outputProcessor);
    }

    public void startReport(ReportDefinition report) {
        long prePageAge = System.currentTimeMillis();
        logger.debug((Object)("Time to pagination " + (prePageAge - this.lastPageAge)));
        this.lastPageAge = prePageAge;
        super.startReport(report);
        this.pageCount = 0;
    }

    protected void debugPrint(LogicalPageBox pageBox) {
    }

    protected boolean isPageFinished() {
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (pageBreak.isOverflow() || !pageBox.isOpen()) {
            this.setLastStateKey(pageBreak.getLastVisibleState());
            return true;
        }
        return false;
    }

    protected boolean performPagination(LayoutPagebreakHandler layoutPagebreakHandler, boolean performOutput) throws ContentProcessingException {
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (pageBreak.isOverflow() || !pageBox.isOpen()) {
            boolean repeat;
            this.setLastStateKey(pageBreak.getLastVisibleState());
            this.setPagebreaks(this.getPagebreaks() + 1);
            pageBox.setAllVerticalBreaks(pageBreak.getAllBreaks());
            ++this.pageCount;
            this.debugPrint(pageBox);
            OutputProcessor outputProcessor = this.getOutputProcessor();
            long nextOffset = pageBreak.getLastPosition();
            long pageOffset = pageBox.getPageOffset();
            if (performOutput) {
                if (outputProcessor.isNeedAlignedPage()) {
                    LogicalPageBox box = this.fillPhysicalPagesStep.compute(pageBox, pageOffset, nextOffset);
                    outputProcessor.processContent(box);
                } else {
                    outputProcessor.processContent(pageBox);
                }
            } else {
                outputProcessor.processRecomputedContent(pageBox);
            }
            this.lastPageAge = System.currentTimeMillis();
            boolean bl = repeat = pageBox.isOpen() || pageBox.getHeight() > nextOffset;
            if (repeat) {
                pageBox.setPageOffset(nextOffset);
                long shift = this.cleanPaginatedBoxesStep.compute(pageBox);
                if (shift > 0L) {
                    InstanceID shiftNode = this.cleanPaginatedBoxesStep.getShiftNode();
                    this.applyPageShiftValuesStep.compute(pageBox, shift, shiftNode);
                }
                if (pageBreak.isNextPageContainsContent()) {
                    if (layoutPagebreakHandler != null) {
                        layoutPagebreakHandler.pageStarted();
                    }
                    return true;
                }
                this.pageStartPending = true;
                return false;
            }
            pageBox.setPageOffset(nextOffset);
            outputProcessor.processingFinished();
            return false;
        }
        return false;
    }

    public boolean clearPendingPageStart(LayoutPagebreakHandler layoutPagebreakHandler) {
        if (!this.pageStartPending) {
            return false;
        }
        if (layoutPagebreakHandler != null) {
            layoutPagebreakHandler.pageStarted();
        }
        this.pageStartPending = false;
        return true;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public boolean isCurrentPageEmpty() {
        LogicalPageBox logicalPageBox = this.getPageBox();
        if (logicalPageBox == null) {
            throw new IllegalStateException("LogicalPageBox being null? You messed it up again!");
        }
        PageBreakPositionList breakPositionList = logicalPageBox.getAllVerticalBreaks();
        long masterBreak = breakPositionList.getLastMasterBreak();
        boolean nextPageContainsContent = logicalPageBox.getHeight() > masterBreak;
        return !nextPageContainsContent;
    }

    public boolean isPageStartPending() {
        return this.pageStartPending;
    }

    public boolean isPendingPageHack() {
        return true;
    }
}

