/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.AbstractReportProcessTask;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.GraphicsContentInterceptor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.GraphicsOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.StreamGraphicsOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.encoder.ImageEncoder;
import org.pentaho.reporting.libraries.base.encoder.ImageEncoderRegistry;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class Graphics2DReportProcessTask
extends AbstractReportProcessTask {
    public void run() {
        if (!this.isValid()) {
            this.setError((Throwable)((Object)new ReportProcessingException("Error: The task is not configured properly.")));
            return;
        }
        this.setError(null);
        try {
            MasterReport masterReport = this.getReport();
            Configuration configuration = masterReport.getConfiguration();
            boolean alphaChannel = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.AlphaChannel"));
            String mimeType = this.computeMimeType(configuration);
            float quality = ParserUtil.parseFloat((String)configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.Quality"), (float)0.9f);
            GraphicsOutputProcessor outputProcessor = new GraphicsOutputProcessor(new StreamGraphicsOutputProcessorMetaData(configuration), masterReport.getResourceManager());
            StreamReportProcessor streamReportProcessor = new StreamReportProcessor(masterReport, outputProcessor);
            ReportProgressListener[] progressListeners = this.getReportProgressListeners();
            for (int i = 0; i < progressListeners.length; ++i) {
                ReportProgressListener listener = progressListeners[i];
                streamReportProcessor.addReportProgressListener(listener);
            }
            ImageGeneratorInterceptor interceptor = new ImageGeneratorInterceptor();
            outputProcessor.setInterceptor(interceptor);
            streamReportProcessor.processReport();
            streamReportProcessor.close();
            ContentLocation contentLocation = this.getBodyContentLocation();
            NameGenerator nameGenerator = this.getBodyNameGenerator();
            ContentItem contentItem = contentLocation.createItem(nameGenerator.generateName(null, mimeType));
            BufferedImage image = interceptor.getImage();
            ImageEncoder imageEncoder = ImageEncoderRegistry.getInstance().createEncoder(mimeType);
            OutputStream outputStream = contentItem.getOutputStream();
            imageEncoder.encodeImage((Image)image, outputStream, quality, alphaChannel);
            outputStream.close();
        }
        catch (Throwable e) {
            this.setError(e);
        }
    }

    protected String computeMimeType(Configuration configuration) {
        return configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.EncoderMime", "image/png");
    }

    public String getReportMimeType() {
        MasterReport masterReport = this.getReport();
        Configuration configuration = masterReport.getConfiguration();
        return this.computeMimeType(configuration);
    }

    private static class ImageGeneratorInterceptor
    implements GraphicsContentInterceptor {
        private BufferedImage image;

        private ImageGeneratorInterceptor() {
        }

        public void processLogicalPage(LogicalPageKey key, PageDrawable page) {
            Dimension preferredSize = page.getPreferredSize();
            this.image = new BufferedImage(preferredSize.width, preferredSize.height, 2);
            Graphics2D g2 = this.image.createGraphics();
            page.draw(g2, new Rectangle2D.Double(0.0, 0.0, preferredSize.width, preferredSize.height));
            g2.dispose();
        }

        public void processPhysicalPage(PhysicalPageKey key, PageDrawable page) {
        }

        public boolean isPhysicalPageAccepted(PhysicalPageKey key) {
            return false;
        }

        public boolean isLogicalPageAccepted(LogicalPageKey key) {
            return true;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

