/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.AbstractPageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageFlowSelector;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.GraphicsContentInterceptor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.GraphicsOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.LogicalPageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.PhysicalPageDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class GraphicsOutputProcessor
extends AbstractPageableOutputProcessor {
    private OutputProcessorMetaData metaData;
    private GraphicsContentInterceptor interceptor;
    private ResourceManager resourceManager;

    public GraphicsOutputProcessor(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        DefaultFontStorage fontStorage = new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
        this.metaData = new GraphicsOutputProcessorMetaData(configuration, (FontStorage)fontStorage);
        this.resourceManager = new ResourceManager();
        this.resourceManager.registerDefaults();
    }

    public GraphicsOutputProcessor(Configuration configuration, ResourceManager resourceManager) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        DefaultFontStorage fontStorage = new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
        this.metaData = new GraphicsOutputProcessorMetaData(configuration, (FontStorage)fontStorage);
        this.resourceManager = resourceManager;
    }

    public GraphicsOutputProcessor(OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.metaData = metaData;
        this.resourceManager = resourceManager;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public GraphicsContentInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(GraphicsContentInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    protected final PageFlowSelector getFlowSelector() {
        return this.getInterceptor();
    }

    protected void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) {
        PhysicalPageBox page = pageGrid.getPage(row, col);
        if (page != null) {
            LogicalPageDrawable drawable = new LogicalPageDrawable(logicalPage, this.metaData, this.resourceManager);
            PhysicalPageDrawable pageDrawable = new PhysicalPageDrawable(drawable, page);
            this.interceptor.processPhysicalPage(pageKey, pageDrawable);
        }
    }

    protected void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) {
        LogicalPageDrawable drawable = new LogicalPageDrawable(logicalPage, this.metaData, this.resourceManager);
        this.interceptor.processLogicalPage(key, drawable);
    }

    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.metaData.commit();
    }
}

