/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.LogicalPageDrawable;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class PhysicalPageDrawable
implements PageDrawable {
    private LogicalPageDrawable pageDrawable;
    private PageFormat pageFormat;
    private long globalX;
    private long globalY;

    public PhysicalPageDrawable(LogicalPageDrawable pageDrawable, PhysicalPageBox page) {
        if (pageDrawable == null) {
            throw new NullPointerException();
        }
        if (page == null) {
            throw new NullPointerException();
        }
        this.pageDrawable = pageDrawable;
        this.globalX = page.getGlobalX();
        this.globalY = page.getGlobalY();
        Paper p = new Paper();
        float marginLeft = (float)StrictGeomUtility.toExternalValue(page.getImageableX());
        float marginRight = (float)StrictGeomUtility.toExternalValue(page.getWidth() - page.getImageableWidth() - page.getImageableX());
        float marginTop = (float)StrictGeomUtility.toExternalValue(page.getImageableY());
        float marginBottom = (float)StrictGeomUtility.toExternalValue(page.getHeight() - page.getImageableHeight() - page.getImageableY());
        switch (page.getOrientation()) {
            case 1: {
                p.setSize(StrictGeomUtility.toExternalValue(page.getWidth()), StrictGeomUtility.toExternalValue(page.getHeight()));
                PageFormatFactory.getInstance().setBorders(p, marginTop, marginLeft, marginBottom, marginRight);
                break;
            }
            case 0: {
                p.setSize(StrictGeomUtility.toExternalValue(page.getHeight()), StrictGeomUtility.toExternalValue(page.getWidth()));
                PageFormatFactory.getInstance().setBorders(p, marginRight, marginTop, marginLeft, marginBottom);
                break;
            }
            case 2: {
                p.setSize(StrictGeomUtility.toExternalValue(page.getHeight()), StrictGeomUtility.toExternalValue(page.getWidth()));
                PageFormatFactory.getInstance().setBorders(p, marginLeft, marginBottom, marginRight, marginTop);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected page-orientation encountered.");
            }
        }
        this.pageFormat = new PageFormat();
        this.pageFormat.setPaper(p);
        this.pageFormat.setOrientation(page.getOrientation());
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
    }

    public boolean isPreserveAspectRatio() {
        return true;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        g2.translate(this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
        this.pageDrawable.draw(g2, new Rectangle2D.Double(StrictGeomUtility.toExternalValue(this.globalX), StrictGeomUtility.toExternalValue(this.globalY), this.pageFormat.getImageableWidth(), this.pageFormat.getImageableHeight()));
    }

    public RenderNode[] getNodesAt(double x, double y, String namespace, String name) {
        return this.pageDrawable.getNodesAt(x - this.pageFormat.getImageableX(), y - this.pageFormat.getImageableY(), namespace, name);
    }

    public RenderNode[] getNodesAt(double x, double y, double width, double height, String namespace, String name) {
        return this.pageDrawable.getNodesAt(x - this.pageFormat.getImageableX(), y - this.pageFormat.getImageableY(), width, height, namespace, name);
    }
}

