/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal;

import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class StreamGraphicsOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public StreamGraphicsOutputProcessorMetaData(Configuration configuration) {
        this(configuration, (FontStorage)new DefaultFontStorage((FontRegistry)new AWTFontRegistry()));
    }

    public StreamGraphicsOutputProcessorMetaData(Configuration configuration, FontStorage storage) {
        super(configuration, storage);
        ExtendedConfigurationWrapper extendedConfig;
        double deviceResolution;
        this.addFeature(OutputProcessorFeature.FAST_FONTRENDERING);
        this.addFeature(OutputProcessorFeature.BACKGROUND_IMAGE);
        this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        this.addFeature(OutputProcessorFeature.SPACING_SUPPORTED);
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.WatermarkPrinted"))) {
            this.addFeature(OutputProcessorFeature.WATERMARK_SECTION);
        }
        if ((deviceResolution = (double)(extendedConfig = new ExtendedConfigurationWrapper(configuration)).getIntProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.DeviceResolution", 0)) > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
    }

    public String getExportDescriptor() {
        return "pageable/X-AWT-Graphics";
    }
}

