/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfOutputProcessor;

public final class PdfReportUtil {
    private static final Log logger = LogFactory.getLog(PdfReportUtil.class);

    private PdfReportUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createPDF(MasterReport report, File fileName) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (fileName == null) {
            throw new NullPointerException();
        }
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fileName));
            boolean retval = PdfReportUtil.createPDF(report, out);
            out.close();
            out = null;
            boolean bl = retval;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"Writing PDF failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Saving PDF failed.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createPDF(MasterReport report, OutputStream out) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (out == null) {
            throw new NullPointerException();
        }
        AbstractReportProcessor proc = null;
        try {
            PdfOutputProcessor outputProcessor = new PdfOutputProcessor(report.getConfiguration(), out, report.getResourceManager());
            proc = new PageableReportProcessor(report, outputProcessor);
            proc.processReport();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"Writing PDF failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Error e) {
            logger.error((Object)"Writing PDF failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (proc != null) {
                proc.close();
            }
        }
    }

    public static boolean createPDF(MasterReport report, String fileName) {
        return PdfReportUtil.createPDF(report, new File(fileName));
    }
}

