/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.MasterReportType;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.text.LegacyFontMetrics;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.fonts.FontMappingUtility;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontFontMetrics;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class PdfOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    private LFUMap normalizedFontNameCache;

    public PdfOutputProcessorMetaData(Configuration configuration, ITextFontStorage fontStorage) {
        super(configuration, (FontStorage)fontStorage);
        ExtendedConfigurationWrapper extendedConfig;
        double deviceResolution;
        this.setFamilyMapping(null, "Helvetica");
        this.addFeature(OutputProcessorFeature.FAST_FONTRENDERING);
        this.addFeature(OutputProcessorFeature.BACKGROUND_IMAGE);
        this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        this.addFeature(OutputProcessorFeature.SPACING_SUPPORTED);
        this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.WatermarkPrinted"))) {
            this.addFeature(OutputProcessorFeature.WATERMARK_SECTION);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.EmbedFonts"))) {
            this.addFeature(OutputProcessorFeature.EMBED_ALL_FONTS);
        }
        if ((deviceResolution = (double)(extendedConfig = new ExtendedConfigurationWrapper(configuration)).getIntProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.DeviceResolution", 0)) > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        this.normalizedFontNameCache = new LFUMap(500);
    }

    public String getNormalizedFontFamilyName(String name) {
        Object fromCache;
        if (name != null && (fromCache = this.normalizedFontNameCache.get((Object)name)) != null) {
            return (String)fromCache;
        }
        String mappedName = super.getNormalizedFontFamilyName(name);
        if (FontMappingUtility.isSerif((String)mappedName)) {
            mappedName = "Times";
        } else if (FontMappingUtility.isSansSerif((String)mappedName)) {
            mappedName = "Helvetica";
        } else if (FontMappingUtility.isCourier((String)mappedName)) {
            mappedName = "Courier";
        } else if (FontMappingUtility.isSymbol((String)mappedName)) {
            mappedName = "Symbol";
        }
        if (name != null) {
            this.normalizedFontNameCache.put((Object)name, (Object)mappedName);
        }
        return mappedName;
    }

    public String getExportDescriptor() {
        return "pageable/pdf";
    }

    public ITextFontStorage getITextFontStorage() {
        return (ITextFontStorage)this.getFontStorage();
    }

    public BaseFontFontMetrics getBaseFontFontMetrics(String fontFamily, double fontSize, boolean bold, boolean italics, String encoding, boolean embedded, boolean antiAliasing) throws IllegalArgumentException {
        try {
            FontMetrics metrics = super.getFontMetrics(fontFamily, fontSize, bold, italics, encoding, embedded, antiAliasing);
            if (metrics instanceof LegacyFontMetrics) {
                LegacyFontMetrics lm = (LegacyFontMetrics)metrics;
                return (BaseFontFontMetrics)lm.getParent();
            }
            return (BaseFontFontMetrics)metrics;
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("Ups, I did it again! ClassCastException in PdfOutputProcessorMetaData");
        }
    }

    public boolean isExtraContentElement(StyleSheet style, ReportAttributeMap attributes) {
        if (!this.isFeatureSupported(OutputProcessorFeature.DETECT_EXTRA_CONTENT)) {
            return false;
        }
        Object o = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
        if (o instanceof MasterReportType) {
            return false;
        }
        if (super.isExtraContentElement(style, attributes)) {
            return true;
        }
        return attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pdf", "scriptAction") != null;
    }
}

