/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

import java.awt.print.Paper;
import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.DefaultFontMapper;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.FontMapper;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PlaintextDataChunk;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.EncodingUtilities;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecification;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecificationManager;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;

public abstract class AbstractEpsonPrinterDriver
implements PrinterDriver {
    public static final String OP_NO_ASSIGN_CHAR_TABLE = "no.assign.character.table";
    public static final String FONT_15_CPI = "Epson.Font-15CPI-available";
    private PrinterSpecification printerSpecification;
    private FontMapper fontMapper;
    private OutputStream out;
    private float charsPerInch;
    private float linesPerInch;
    private EncodingUtilities encodingUtilities;
    private boolean firstPage;
    private byte fallBackCharset;
    private DriverState driverState;
    private String encoding;

    protected AbstractEpsonPrinterDriver(OutputStream out, float charsPerInch, float linesPerInch, String printerModel) {
        if (out == null) {
            throw new NullPointerException();
        }
        if (printerModel == null) {
            throw new NullPointerException();
        }
        this.out = out;
        this.charsPerInch = charsPerInch;
        this.linesPerInch = linesPerInch;
        this.printerSpecification = this.lookupPrinterSpecification(printerModel);
        this.fontMapper = new DefaultFontMapper();
        this.firstPage = true;
        this.driverState = new DriverState();
        if (!this.isValidCPI(charsPerInch)) {
            throw new IllegalArgumentException("The given CPI of '" + charsPerInch + "' is invalid for the selected printer model ('" + printerModel + "'.");
        }
    }

    private boolean isValidCPI(float charsPerInch) {
        if (charsPerInch == 10.0f) {
            return true;
        }
        if (charsPerInch == 12.0f) {
            return true;
        }
        if (charsPerInch == 17.14f) {
            return true;
        }
        if (charsPerInch == 20.0f) {
            return true;
        }
        return charsPerInch == 15.0f && this.getPrinterSpecification().isFeatureAvailable(FONT_15_CPI);
    }

    public DriverState getDriverState() {
        return this.driverState;
    }

    public FontMapper getFontMapper() {
        return this.fontMapper;
    }

    public void setFontMapper(FontMapper fontMapper) {
        if (fontMapper == null) {
            throw new NullPointerException();
        }
        this.fontMapper = fontMapper;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected boolean isFirstPage() {
        return this.firstPage;
    }

    public PrinterSpecification getPrinterSpecification() {
        return this.printerSpecification;
    }

    public void endLine(boolean overflow) throws IOException {
        if (!overflow) {
            this.out.write(13);
            this.out.write(10);
        } else {
            this.out.write(127);
        }
    }

    public void endPage(boolean overflow) throws IOException {
        if (!overflow) {
            this.out.write(12);
        }
    }

    public float getCharactersPerInch() {
        return this.charsPerInch;
    }

    public float getLinesPerInch() {
        return this.linesPerInch;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void printChunk(PlaintextDataChunk chunk) throws IOException {
        String text = chunk.getText().substring(0, chunk.getWidth());
        String fd = chunk.getFont();
        this.sendDefineFont(this.fontMapper.getPrinterFont(fd));
        this.sendFontStyle(chunk.isBold(), chunk.isItalic(), chunk.isUnderline(), chunk.isStrikethrough());
        this.getEncodingUtilities(this.encoding).writeEncodedText(text, this.out);
    }

    protected abstract void sendFontStyle(boolean var1, boolean var2, boolean var3, boolean var4) throws IOException;

    protected void sendDefineFont(byte printerFont) throws IOException {
        if (this.getDriverState().getFont() != printerFont) {
            this.getOut().write(27);
            this.getOut().write(107);
            this.getOut().write(printerFont);
            this.getDriverState().setFont(printerFont);
        }
    }

    public void printEmptyChunk(int count) throws IOException {
        this.sendFontStyle(this.getDriverState().isBold(), this.getDriverState().isItalic(), false, false);
        for (int i = 0; i < count; ++i) {
            this.out.write(32);
        }
    }

    public void printRaw(byte[] raw) throws IOException {
        this.out.write(raw);
    }

    public void startLine() throws IOException {
        this.sendFontStyle(false, false, false, false);
        int manualLeftBorder = this.getDriverState().getManualLeftBorder();
        for (int i = 0; i < manualLeftBorder; ++i) {
            this.out.write(32);
        }
    }

    public void startPage(Paper paper, String encoding) throws IOException {
        this.encoding = encoding;
        float lineHeightPoints = 72.0f / this.getLinesPerInch();
        float charWidthPoints = 72.0f / this.getCharactersPerInch();
        this.sendResetPrinter();
        this.driverState.reset();
        this.sendDefineLineSpacing(lineHeightPoints);
        int lines = (int)(paper.getHeight() / 72.0 * (double)this.getLinesPerInch());
        this.sendDefinePageLengthInLines(lines);
        this.sendDefineCharacterWidth(this.getCharactersPerInch());
        PageFormatFactory fact = PageFormatFactory.getInstance();
        int borderLeft = (int)(fact.getLeftBorder(paper) / (double)charWidthPoints);
        int borderRight = (int)(fact.getRightBorder(paper) / (double)charWidthPoints);
        this.sendDefineHorizontalBorders(borderLeft, borderRight);
        int borderTop = (int)(fact.getTopBorder(paper) / (double)lineHeightPoints);
        for (int i = 0; i < borderTop; ++i) {
            this.startLine();
            this.endLine(false);
        }
    }

    protected void sendDefineCharacterWidth(float charactersPerInch) throws IOException {
        if (charactersPerInch == 10.0f) {
            this.getOut().write(18);
            this.getOut().write(27);
            this.getOut().write(80);
        } else if (charactersPerInch == 12.0f) {
            this.getOut().write(18);
            this.getOut().write(27);
            this.getOut().write(77);
        } else if (charactersPerInch == 15.0f) {
            this.getOut().write(18);
            this.getOut().write(27);
            this.getOut().write(103);
        } else if (charactersPerInch == 17.14f) {
            this.getOut().write(15);
            this.getOut().write(27);
            this.getOut().write(80);
        } else if (charactersPerInch == 20.0f) {
            this.getOut().write(15);
            this.getOut().write(27);
            this.getOut().write(77);
        } else {
            throw new IllegalArgumentException("The given character width is invalid");
        }
    }

    protected void sendResetPrinter() throws IOException {
        this.out.write(27);
        this.out.write(64);
    }

    protected abstract void sendDefineLineSpacing(float var1) throws IOException;

    protected void sendDefinePageLengthInLines(int paperSizeInLines) throws IOException {
        this.getOut().write(27);
        this.getOut().write(67);
        this.getOut().write(paperSizeInLines);
    }

    protected void sendDefineHorizontalBorders(int left, int right) throws IOException {
        if (left < 256) {
            this.getOut().write(27);
            this.getOut().write(108);
            this.getOut().write(left);
            this.getDriverState().setManualLeftBorder(0);
        } else {
            this.getOut().write(27);
            this.getOut().write(108);
            this.getOut().write(255);
            this.getDriverState().setManualLeftBorder(left - 255);
        }
    }

    protected void sendDefineCodepage(String encoding, int characterTable) throws IOException {
        if (this.getPrinterSpecification().isFeatureAvailable(OP_NO_ASSIGN_CHAR_TABLE)) {
            this.out.write(27);
            this.out.write(82);
            this.out.write(this.getFallBackCharset());
        } else {
            byte[] cp = this.getPrinterSpecification().getEncoding(encoding).getCode();
            this.out.write(27);
            this.out.write(40);
            this.out.write(116);
            this.out.write(3);
            this.out.write(0);
            this.out.write(characterTable);
            this.out.write(cp);
        }
        this.out.write(27);
        this.out.write(116);
        this.out.write(0);
    }

    protected void sendDefineUserCharacters() {
    }

    protected EncodingUtilities getEncodingUtilities(String encoding) throws IOException {
        if (this.encodingUtilities != null && this.encodingUtilities.getEncoding().equals(encoding)) {
            return this.encodingUtilities;
        }
        this.encodingUtilities = new EncodingUtilities(encoding);
        this.sendDefineCodepage(encoding, 0);
        return this.encodingUtilities;
    }

    protected abstract PrinterSpecificationManager getPrinterSpecificationManager();

    private PrinterSpecification lookupPrinterSpecification(String model) {
        PrinterSpecificationManager printerSpecificationManager = this.getPrinterSpecificationManager();
        if (model == null) {
            return PrinterSpecificationManager.getGenericPrinter();
        }
        PrinterSpecification printerModel = printerSpecificationManager.getPrinter(model);
        if (printerModel == null) {
            throw new IllegalArgumentException("The printer model is not supported.");
        }
        return printerModel;
    }

    public byte getFallBackCharset() {
        return this.fallBackCharset;
    }

    public void setFallBackCharset(byte fallBackCharset) {
        this.fallBackCharset = fallBackCharset;
    }

    protected static class DriverState {
        private boolean bold;
        private boolean underline;
        private boolean italic;
        private boolean strikethrough;
        private byte font;
        private int manualLeftBorder;

        protected DriverState() {
        }

        public boolean isBold() {
            return this.bold;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public void setItalic(boolean italic) {
            this.italic = italic;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public void setUnderline(boolean underline) {
            this.underline = underline;
        }

        public byte getFont() {
            return this.font;
        }

        public void setFont(byte font) {
            this.font = font;
        }

        public int getManualLeftBorder() {
            return this.manualLeftBorder;
        }

        public void setManualLeftBorder(int manualLeftBorder) {
            this.manualLeftBorder = manualLeftBorder;
        }

        public boolean isStrikethrough() {
            return this.strikethrough;
        }

        public void setStrikethrough(boolean strikethrough) {
            this.strikethrough = strikethrough;
        }

        public void reset() {
            this.bold = false;
            this.italic = false;
            this.strikethrough = false;
            this.underline = false;
            this.font = 0;
            this.manualLeftBorder = 0;
        }
    }
}

