/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.AbstractEpsonPrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecificationManager;

public class Epson9PinPrinterDriver
extends AbstractEpsonPrinterDriver {
    private static final byte TWELVECPI = 1;
    private static final byte CONDENSED = 4;
    private static final byte BOLD = 8;
    private static final byte ITALICS = 64;
    private static final byte UNDERLINE = -128;
    private int masterselect;
    private static PrinterSpecificationManager printerSpecificationManager;
    private static final String SPECIFICATION_RESOURCE = "/org/pentaho/reporting/engine/classic/core/modules/output/pageable/plaintext/driver/epson-9pin-printer-specifications.properties";
    public static final String EPSON_9PIN_PRINTER_TYPE = "org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.9PinPrinterType";

    public Epson9PinPrinterDriver(OutputStream out, float charsPerInch, float linesPerInch, String printerModel) {
        super(out, charsPerInch, linesPerInch, printerModel);
    }

    protected void sendDefineLineSpacing(float lineHeightInPoints) throws IOException {
        int spacePar = (int)(lineHeightInPoints * 3.0f);
        OutputStream outputStream = this.getOut();
        outputStream.write(27);
        outputStream.write(51);
        outputStream.write(spacePar);
    }

    protected void sendFontStyle(boolean bold, boolean italic, boolean underline, boolean strikeTrough) throws IOException {
        boolean useMasterSelect;
        OutputStream out = this.getOut();
        AbstractEpsonPrinterDriver.DriverState driverState = this.getDriverState();
        byte[] bytes = new byte[8];
        int byteindex = 0;
        if (driverState.isBold()) {
            if (!bold) {
                this.masterselect &= 0xFFFFFFF7;
                bytes[byteindex] = 27;
                bytes[++byteindex] = 70;
                ++byteindex;
            }
        } else if (bold) {
            this.masterselect |= 8;
            bytes[byteindex] = 27;
            bytes[++byteindex] = 69;
            ++byteindex;
        }
        if (driverState.isItalic()) {
            if (!italic) {
                this.masterselect &= 0xFFFFFFBF;
                bytes[byteindex] = 27;
                bytes[++byteindex] = 53;
                ++byteindex;
            }
        } else if (italic) {
            this.masterselect |= 0x40;
            bytes[byteindex] = 27;
            bytes[++byteindex] = 52;
            ++byteindex;
        }
        if (driverState.isUnderline()) {
            if (!underline) {
                this.masterselect &= 0x7F;
                bytes[byteindex] = 27;
                bytes[++byteindex] = 45;
                bytes[++byteindex] = 0;
                ++byteindex;
            }
        } else if (underline) {
            this.masterselect |= 0xFFFFFF80;
            bytes[byteindex] = 27;
            bytes[++byteindex] = 45;
            bytes[++byteindex] = 1;
            ++byteindex;
        }
        if (useMasterSelect = ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.UseEpsonMasterSelect")) {
            out.write(27);
            out.write(33);
            out.write((byte)this.masterselect);
        } else {
            for (int i = 0; i < byteindex; ++i) {
                out.write(bytes[i]);
            }
        }
        driverState.setBold(bold);
        driverState.setItalic(italic);
        driverState.setUnderline(underline);
        driverState.setStrikethrough(false);
    }

    protected void sendDefineCharacterWidth(float charactersPerInch) throws IOException {
        byte[] bytes = new byte[4];
        int byteindex = 0;
        boolean useMasterSelect = ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.UseEpsonMasterSelect");
        if (charactersPerInch == 10.0f) {
            this.masterselect &= 0xFFFFFFFE;
            bytes[byteindex++] = 18;
            bytes[byteindex++] = 27;
            bytes[byteindex++] = 80;
        } else if (charactersPerInch == 12.0f) {
            this.masterselect |= 1;
            bytes[byteindex++] = 18;
            bytes[byteindex++] = 27;
            bytes[byteindex++] = 77;
        } else if (charactersPerInch == 15.0f) {
            bytes[byteindex++] = 18;
            bytes[byteindex++] = 27;
            bytes[byteindex++] = 103;
            useMasterSelect = false;
        } else if (charactersPerInch == 17.14f) {
            this.masterselect |= 4;
            this.masterselect &= 0xFFFFFFFE;
            bytes[byteindex++] = 15;
            bytes[byteindex++] = 27;
            bytes[byteindex++] = 80;
        } else if (charactersPerInch == 20.0f) {
            this.masterselect |= 4;
            this.masterselect |= 1;
            bytes[byteindex++] = 15;
            bytes[byteindex++] = 27;
            bytes[byteindex++] = 77;
        } else {
            throw new IllegalArgumentException("The given character width is invalid");
        }
        OutputStream outputStream = this.getOut();
        if (useMasterSelect) {
            outputStream.write(27);
            outputStream.write(33);
            outputStream.write((byte)this.masterselect);
        } else {
            for (int i = 0; i < byteindex; ++i) {
                outputStream.write(bytes[i]);
            }
        }
    }

    protected PrinterSpecificationManager getPrinterSpecificationManager() {
        return Epson9PinPrinterDriver.loadSpecificationManager();
    }

    public static synchronized PrinterSpecificationManager loadSpecificationManager() {
        if (printerSpecificationManager == null) {
            printerSpecificationManager = new PrinterSpecificationManager();
            printerSpecificationManager.load(SPECIFICATION_RESOURCE);
        }
        return printerSpecificationManager;
    }

    public static String getDefaultPrinter() {
        return ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty(EPSON_9PIN_PRINTER_TYPE, "Generic 9-Pin printer");
    }
}

