/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

import java.awt.print.Paper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.DefaultFontMapper;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PlaintextDataChunk;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.EncodingUtilities;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterEncoding;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecification;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;

public class IBMCompatiblePrinterDriver
implements PrinterDriver {
    public static final int QUALITY_UNDEFINED = -1;
    public static final int QUALITY_FAST_DRAFT = 0;
    public static final int QUALITY_DRAFT = 64;
    public static final int QUALITY_LETTER = 128;
    public static final int QUALITY_ENHANCED_LETTER = 192;
    public static final int QUALITY_DEFAULT = 255;
    private OutputStream out;
    private float charsPerInch;
    private float linesPerInch;
    private byte[] endOfPage;
    private boolean autoLF;
    private int printQuality;
    private PrinterSpecification printerSpecification;
    private EncodingUtilities encodingUtilities;
    private DefaultFontMapper fontMapper;
    private DriverState driverState;
    private boolean firstPage;
    private String encoding;

    public IBMCompatiblePrinterDriver(OutputStream out, float charsPerInch, float linesPerInch) {
        this.out = out;
        this.charsPerInch = charsPerInch;
        this.linesPerInch = linesPerInch;
        this.endOfPage = new byte[]{12};
        this.printerSpecification = new GenericIBMPrinterSpecification();
        this.fontMapper = new DefaultFontMapper();
        this.fontMapper.setDefaultFont((byte)127);
        this.driverState = new DriverState();
        this.firstPage = true;
    }

    public void setAutoLF(boolean autoLF) {
        this.autoLF = autoLF;
    }

    public boolean isAutoLF() {
        return this.autoLF;
    }

    public int getPrintQuality() {
        return this.printQuality;
    }

    public void setPrintQuality(int printQuality) {
        this.printQuality = printQuality;
    }

    public void endLine(boolean overflow) throws IOException {
        if (!overflow) {
            this.out.write(13);
            if (!this.autoLF) {
                this.out.write(10);
            }
        }
    }

    public void endPage(boolean overflow) throws IOException {
        if (!overflow) {
            this.printRaw(this.endOfPage);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public float getCharactersPerInch() {
        return this.charsPerInch;
    }

    public float getLinesPerInch() {
        return this.linesPerInch;
    }

    public void printChunk(PlaintextDataChunk chunk) throws IOException {
        String text = chunk.getText().substring(0, chunk.getWidth());
        String fd = chunk.getFont();
        this.sendDefineFont(this.fontMapper.getPrinterFont(fd));
        this.sendFontStyle(chunk.isBold(), chunk.isItalic(), chunk.isUnderline());
        this.getEncodingUtilities(this.encoding).writeEncodedText(text, this.out);
    }

    public void printEmptyChunk(int count) throws IOException {
        this.sendFontStyle(this.driverState.isBold(), this.driverState.isItalic(), false);
        for (int i = 0; i < count; ++i) {
            this.out.write(32);
        }
    }

    public void printRaw(byte[] raw) throws IOException {
        this.out.write(raw);
    }

    public void startLine() throws IOException {
        int manualLeftBorder = this.driverState.getManualLeftBorder();
        for (int i = 0; i < manualLeftBorder; ++i) {
            this.out.write(32);
        }
    }

    public void startPage(Paper paper, String encoding) throws IOException {
        this.encoding = encoding;
        float charWidthPoints = 72.0f / this.getCharactersPerInch();
        float lineHeightPoints = 72.0f / this.getLinesPerInch();
        if (this.firstPage) {
            this.sendAutoLF(this.isAutoLF());
            this.sendDefinePrintQuality(this.getPrintQuality());
            this.sendDefineCharacterWidth(this.getCharactersPerInch());
            this.firstPage = false;
        }
        this.sendLineSpacing((int)lineHeightPoints);
        int lines = (int)(paper.getHeight() / 72.0 * (double)this.getLinesPerInch());
        this.sendDefinePageLengthInLines(lines);
        PageFormatFactory fact = PageFormatFactory.getInstance();
        int borderLeft = (int)(fact.getLeftBorder(paper) / (double)charWidthPoints);
        int borderRight = (int)(fact.getRightBorder(paper) / (double)charWidthPoints);
        int borderTop = (int)(fact.getTopBorder(paper) / (double)lineHeightPoints);
        this.sendDefineHorizontalBorders(borderLeft, borderRight);
        for (int i = 0; i < borderTop; ++i) {
            this.startLine();
            this.endLine(false);
        }
    }

    public void sendLineSpacing(int lineHeight) throws IOException {
        this.out.write(27);
        this.out.write(65);
        this.out.write(lineHeight);
        this.out.write(27);
        this.out.write(50);
    }

    private void sendDefineHorizontalBorders(int left, int right) throws IOException {
        this.out.write(27);
        this.out.write(88);
        this.out.write(left);
        this.out.write(right);
    }

    private void sendDefinePageLengthInLines(int lines) throws IOException {
        this.out.write(27);
        this.out.write(67);
        this.out.write(lines);
    }

    private void sendDefinePrintQuality(int quality) throws IOException {
        this.out.write(27);
        this.out.write(91);
        this.out.write(100);
        this.out.write(1);
        this.out.write(0);
        this.out.write(quality);
    }

    private void sendFontStyle(boolean bold, boolean italic, boolean underline) throws IOException {
        if (this.driverState.isBold()) {
            if (!bold) {
                this.out.write(27);
                this.out.write(70);
            }
        } else if (bold) {
            this.out.write(27);
            this.out.write(69);
        }
        if (this.driverState.isItalic()) {
            if (!italic) {
                this.out.write(27);
                this.out.write(37);
                this.out.write(72);
            }
        } else if (italic) {
            this.out.write(27);
            this.out.write(37);
            this.out.write(71);
        }
        if (this.driverState.isUnderline()) {
            if (!underline) {
                this.out.write(27);
                this.out.write(45);
                this.out.write(0);
            }
        } else if (underline) {
            this.out.write(27);
            this.out.write(45);
            this.out.write(1);
        }
        this.driverState.setBold(bold);
        this.driverState.setItalic(italic);
        this.driverState.setUnderline(underline);
    }

    private float sendDefineCharacterWidth(float charsPerInch) throws IOException {
        if (charsPerInch <= 10.0f) {
            this.out.write(18);
            return 10.0f;
        }
        if (charsPerInch <= 12.0f) {
            this.out.write(27);
            this.out.write(58);
            return 12.0f;
        }
        if (charsPerInch <= 15.0f) {
            this.out.write(27);
            this.out.write(103);
            return 15.0f;
        }
        if ((double)charsPerInch <= 17.4) {
            this.out.write(15);
            return 17.4f;
        }
        this.out.write(27);
        this.out.write(15);
        return 20.0f;
    }

    private void sendDefineCodepage(String codePage) throws IOException {
        PrinterEncoding spec = this.getPrinterSpecification().getEncoding(codePage);
        byte[] cp = spec.getCode();
        this.out.write(27);
        this.out.write(91);
        this.out.write(84);
        this.out.write(4);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(cp);
    }

    private PrinterSpecification getPrinterSpecification() {
        return this.printerSpecification;
    }

    private void sendAutoLF(boolean autoLF) throws IOException {
        if (!autoLF) {
            this.out.write(27);
            this.out.write(53);
            this.out.write(48);
        } else {
            this.out.write(27);
            this.out.write(53);
            this.out.write(49);
        }
    }

    private void sendDefineFont(byte b) throws IOException {
        if (this.driverState.getFont() != b) {
            this.out.write(27);
            this.out.write(107);
            this.out.write(b);
            this.driverState.setFont(b);
        }
    }

    protected EncodingUtilities getEncodingUtilities(String encoding) throws IOException {
        if (this.encodingUtilities != null && this.encodingUtilities.getEncoding().equals(encoding)) {
            return this.encodingUtilities;
        }
        this.encodingUtilities = new EncodingUtilities(encoding);
        this.sendDefineCodepage(encoding);
        return this.encodingUtilities;
    }

    private static class DriverState {
        private boolean bold;
        private boolean underline;
        private boolean italic;
        private byte font;
        private int manualLeftBorder;

        protected DriverState() {
        }

        public boolean isBold() {
            return this.bold;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public void setItalic(boolean italic) {
            this.italic = italic;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public void setUnderline(boolean underline) {
            this.underline = underline;
        }

        public byte getFont() {
            return this.font;
        }

        public void setFont(byte font) {
            this.font = font;
        }

        public int getManualLeftBorder() {
            return this.manualLeftBorder;
        }

        public void setManualLeftBorder(int manualLeftBorder) {
            this.manualLeftBorder = manualLeftBorder;
        }
    }

    public static class GenericIBMPrinterSpecification
    implements PrinterSpecification {
        public String getDisplayName() {
            return this.getName();
        }

        public PrinterEncoding getEncoding(String encoding) {
            try {
                return new PrinterEncoding(encoding, encoding, encoding, GenericIBMPrinterSpecification.translateCodePage(encoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("The given encoding is not supported.");
            }
        }

        private static byte[] translateCodePage(String cp) throws UnsupportedEncodingException {
            if (StringUtils.startsWithIgnoreCase((String)cp, (String)"cp")) {
                if (!EncodingRegistry.getInstance().isSupportedEncoding(cp)) {
                    throw new UnsupportedEncodingException("The encoding " + cp + "is not valid");
                }
                String encodingName = cp.substring(2);
                try {
                    int i;
                    if (!Character.isDigit(encodingName.charAt(encodingName.length() - 1))) {
                        i = Integer.parseInt(encodingName.substring(0, encodingName.length() - 1));
                        i += 10000;
                    } else {
                        i = Integer.parseInt(encodingName);
                    }
                    byte[] retval = new byte[]{(byte)(i >> 8), (byte)(i & 0xFF)};
                    return retval;
                }
                catch (Exception e) {
                    throw new UnsupportedEncodingException("The encoding " + cp + "is not valid");
                }
            }
            throw new UnsupportedEncodingException("The encoding " + cp + " is no codepage encoding");
        }

        public String getName() {
            return "Generic IBM Printer Specification";
        }

        public boolean isEncodingSupported(String encoding) {
            try {
                GenericIBMPrinterSpecification.translateCodePage(encoding);
                return true;
            }
            catch (UnsupportedEncodingException use) {
                return false;
            }
        }

        public boolean isFeatureAvailable(String operationName) {
            return true;
        }
    }
}

